-- Deploy gaia:assist_prize to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_assist_prize` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  `stock` int(11) NOT NULL DEFAULT '0',
  `pb_color_pre` varchar(45) DEFAULT NULL,
  `pb_color_bg` varchar(45) DEFAULT NULL,
  `font_color` varchar(45) DEFAULT NULL,
  `start_time` datetime(6) NOT NULL,
  `end_time` datetime(6) NOT NULL,
  `assist_time_long` int(11) DEFAULT NULL,
  `assist_num` int(11) NOT NULL,
  `bg_img_url` varchar(255) DEFAULT NULL,
  `share_button_img_url` varchar(255) DEFAULT NULL,
  `invite_frame_img_url` varchar(255) DEFAULT NULL,
  `assist_frame_img_url` varchar(255) DEFAULT NULL,
  `share_bg_img_url` varchar(255) DEFAULT NULL,
  `description` text,
  `jump_type` varchar(40) DEFAULT NULL,
  `jump_id` int(11) DEFAULT NULL,
  `jump_url` varchar(255) DEFAULT NULL,
  `consume_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `asp_name_idx` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `api_assist_thirdinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `platform_id` varchar(60) NOT NULL,
  `nickname` varchar(255) NOT NULL,
  `img_url` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ast_platformid_idx` (`platform_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `api_assist_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `user_id` int(11) NOT NULL,
  `start_time` datetime(6) NOT NULL,
  `end_time` datetime(6) NOT NULL,
  `a_code` varchar(40) NOT NULL COMMENT '邀请码',
  `assistprize_id` int(11) NOT NULL,
  `suc_count` int(11) NOT NULL DEFAULT '0',
  `receive_status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `asc_user_idx` (`user_id`),
  KEY `asc_prize_idx` (`assistprize_id`),
  KEY `asc_code_idx` (`a_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `api_assister` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `a_code` varchar(40) DEFAULT NULL,
  `thirdrecord_id` int(11) DEFAULT NULL,
  `assist_status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ast_code_idx` (`a_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

COMMIT;
