-- Deploy gaia:create_live_table to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_live_channel` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `person_id` char(32) NOT NULL UNIQUE,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL,
    `title` varchar(128) NOT NULL,
    `cover_url` varchar(128) NOT NULL,
    `status` bool NOT NULL
)
;
ALTER TABLE `api_live_channel` ADD CONSTRAINT `person_id_refs_id_4aa13a0a` FOREIGN KEY (`person_id`) REFERENCES `api_person` (`id`);

CREATE TABLE `api_live_stream` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `channel_id` integer,
    `status` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL,
    `stream_key` varchar(128) NOT NULL,
    `save_replay_url` varchar(128) NOT NULL,
    `title` varchar(128) NOT NULL,
    `cover_url` varchar(128) NOT NULL,
    `topic_id` integer UNIQUE,
    `max_view_num` integer NOT NULL
)
;
ALTER TABLE `api_live_stream` ADD CONSTRAINT `channel_id_refs_id_3d8db62e` FOREIGN KEY (`channel_id`) REFERENCES `api_live_channel` (`id`);
ALTER TABLE `api_live_stream` ADD CONSTRAINT `topic_id_refs_id_5b3218db` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`);
CREATE INDEX `api_live_stream_9e85bf2d` ON `api_live_stream` (`channel_id`);
CREATE INDEX `api_live_stream_68a4455c` ON `api_live_stream` (`stream_key`);
CREATE INDEX `api_live_stream_f8e569df` ON `api_live_stream` (`save_replay_url`);

CREATE TABLE `api_live_white_list` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL UNIQUE
)
;
ALTER TABLE `api_live_white_list` ADD CONSTRAINT `user_id_refs_id_0a276328` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);

CREATE TABLE `api_live_msg` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `person_id` char(32) NOT NULL,
    `stream_id` integer NOT NULL,
    `msg` varchar(128) NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `type` integer NOT NULL
)
;
ALTER TABLE `api_live_msg` ADD CONSTRAINT `person_id_refs_id_9204dd46` FOREIGN KEY (`person_id`) REFERENCES `api_person` (`id`);
ALTER TABLE `api_live_msg` ADD CONSTRAINT `stream_id_refs_id_bb75766a` FOREIGN KEY (`stream_id`) REFERENCES `api_live_stream` (`id`);
CREATE INDEX `api_live_msg_16f39487` ON `api_live_msg` (`person_id`);
CREATE INDEX `api_live_msg_6895d443` ON `api_live_msg` (`stream_id`);
CREATE INDEX `api_live_msg_41e5f0d8` ON `api_live_msg` (`created_time`);

CREATE TABLE `api_streamtag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `live_stream_id` integer NOT NULL,
    `tag_id` integer NOT NULL
)
;
ALTER TABLE `api_streamtag` ADD CONSTRAINT `live_stream_id_refs_id_910c7574` FOREIGN KEY (`live_stream_id`) REFERENCES `api_live_stream` (`id`);
ALTER TABLE `api_streamtag` ADD CONSTRAINT `tag_id_refs_id_55724010` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
CREATE INDEX `api_streamtag_05b8459a` ON `api_streamtag` (`live_stream_id`);
CREATE INDEX `api_streamtag_5659cca2` ON `api_streamtag` (`tag_id`);


COMMIT;
