-- Deploy gaia:create_table_sign_activity to mysql

BEGIN;

CREATE TABLE `api_sign_activity` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(100) NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `rule` longtext,
    `banner` longtext,
    `is_online` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_sign_record` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `activity_id` integer NOT NULL,
    `sign_time` datetime(6) NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_sign_record` ADD CONSTRAINT `user_id_refs_id_a0b2c579` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_sign_record` ADD CONSTRAINT `activity_id_refs_id_dd881637` FOREIGN KEY (`activity_id`) REFERENCES `api_sign_activity` (`id`);
CREATE TABLE `api_last_sign_record` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `activity_id` integer NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `days_count` integer NOT NULL,
    `available_days` integer NOT NULL,
    `is_new` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_last_sign_record` ADD CONSTRAINT `user_id_refs_id_1afc1077` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_last_sign_record` ADD CONSTRAINT `activity_id_refs_id_cfa9656f` FOREIGN KEY (`activity_id`) REFERENCES `api_sign_activity` (`id`);
CREATE TABLE `api_sign_prize` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(256) NOT NULL,
    `short_name` varchar(100) NOT NULL,
    `img_url` varchar(256) NOT NULL,
    `price` double precision NOT NULL,
    `total` integer NOT NULL,
    `count` integer NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_activity_prize_relation` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `activity_id` integer NOT NULL,
    `prize_id` integer,
    `cost` integer NOT NULL,
    `total` integer NOT NULL,
    `count` integer NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_activity_prize_relation` ADD CONSTRAINT `prize_id_refs_id_65d9764d` FOREIGN KEY (`prize_id`) REFERENCES `api_sign_prize` (`id`);
ALTER TABLE `api_activity_prize_relation` ADD CONSTRAINT `activity_id_refs_id_710ca5cc` FOREIGN KEY (`activity_id`) REFERENCES `api_sign_activity` (`id`);
CREATE TABLE `api_user_receive_prize` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `activity_id` integer NOT NULL,
    `prize_id` integer NOT NULL,
    `count` integer NOT NULL,
    `express_no` varchar(100) NOT NULL,
    `user_name` varchar(64) NOT NULL,
    `user_phone` varchar(32),
    `user_address` varchar(128),
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_user_receive_prize` ADD CONSTRAINT `prize_id_refs_id_19551459` FOREIGN KEY (`prize_id`) REFERENCES `api_sign_prize` (`id`);
ALTER TABLE `api_user_receive_prize` ADD CONSTRAINT `activity_id_refs_id_4ea9affe` FOREIGN KEY (`activity_id`) REFERENCES `api_sign_activity` (`id`);
CREATE TABLE `api_sign_activity_config` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `enter_switch` bool NOT NULL,
    `float_window_switch` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;

COMMIT;
