-- Deploy gaia:create_table_sign_v2 to mysql

BEGIN;

CREATE TABLE `api_sign_config_v2` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `cycle` integer NOT NULL,
    `rule` longtext,
    `prize` longtext,
    `operate_config` longtext,
    `is_online` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_user_sign_v2` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `sign_time` date NOT NULL,
    `sign_type` varchar(4) NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL,
    UNIQUE (`user_id`, `sign_time`)
)
;
ALTER TABLE `api_user_sign_v2` ADD CONSTRAINT `user_id_refs_id_d130ed81` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `api_sign_prize_v2` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(256) NOT NULL,
    `img_url` varchar(256) NOT NULL,
    `count` integer NOT NULL,
    `exchange_days` integer NOT NULL,
    `init_count` integer NOT NULL,
    `online_time` date,
    `is_online` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_sign_exchanged_v2` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `prize_id` integer NOT NULL,
    `express_no` integer,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL,
    UNIQUE (`user_id`, `prize_id`)
)
;
ALTER TABLE `api_sign_exchanged_v2` ADD CONSTRAINT `prize_id_refs_id_8fb8155a` FOREIGN KEY (`prize_id`) REFERENCES `api_sign_prize_v2` (`id`);
ALTER TABLE `api_sign_exchanged_v2` ADD CONSTRAINT `user_id_refs_id_c826f613` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `api_userinfo_sign_v2` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `is_remind` bool NOT NULL,
    `add_sign_number` integer NOT NULL,
    `share_code` varchar(256) NOT NULL,
    `last_add_time` date,
    `newest_time` date,
    `last_days` integer NOT NULL,
    `show_tips` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_userinfo_sign_v2` ADD CONSTRAINT `user_id_refs_id_7a9810a8` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);

CREATE INDEX `api_user_sign_v2_6340c63c` ON `api_user_sign_v2` (`user_id`);
CREATE INDEX `api_sign_exchanged_v2_6340c63c` ON `api_sign_exchanged_v2` (`user_id`);
CREATE INDEX `api_sign_exchanged_v2_0f3583ba` ON `api_sign_exchanged_v2` (`prize_id`);
CREATE INDEX `api_userinfo_sign_v2_6340c63c` ON `api_userinfo_sign_v2` (`user_id`);

COMMIT;
