-- Deploy gaia:polymer_2018_03_30_polymer to mysql

BEGIN;
CREATE TABLE `polymer_polymer_tags` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `polymer_id` integer NOT NULL,
    `tag_id` integer NOT NULL,
    UNIQUE (`polymer_id`, `tag_id`)
)
;
ALTER TABLE `polymer_polymer_tags` ADD CONSTRAINT `tag_id_refs_id_29c32152` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
CREATE TABLE `polymer_polymer_banner` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `polymer_id` integer NOT NULL,
    `homepageoperate_id` integer NOT NULL,
    UNIQUE (`polymer_id`, `homepageoperate_id`)
)
;
ALTER TABLE `polymer_polymer_banner` ADD CONSTRAINT `homepageoperate_id_refs_id_58ddbbe4` FOREIGN KEY (`homepageoperate_id`) REFERENCES `api_homepageoperate` (`id`);
CREATE TABLE `polymer_polymer_gadget` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `polymer_id` integer NOT NULL,
    `gadget_id` integer NOT NULL,
    UNIQUE (`polymer_id`, `gadget_id`)
)
;
ALTER TABLE `polymer_polymer_gadget` ADD CONSTRAINT `gadget_id_refs_id_55e78194` FOREIGN KEY (`gadget_id`) REFERENCES `api_gadget` (`id`);
CREATE TABLE `polymer_polymer` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(32) NOT NULL,
    `description` longtext NOT NULL,
    `wiki_item_id` integer NULL,
    `wiki_collect_id` integer NULL,
    `default_tab` integer NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `polymer_polymer` ADD CONSTRAINT `wiki_collect_id_refs_id_30124193` FOREIGN KEY (`wiki_collect_id`) REFERENCES `wiki_collect` (`id`);
ALTER TABLE `polymer_polymer` ADD CONSTRAINT `wiki_item_id_refs_id_1b6e547a` FOREIGN KEY (`wiki_item_id`) REFERENCES `wiki_item` (`id`);
ALTER TABLE `polymer_polymer_tags` ADD CONSTRAINT `polymer_id_refs_id_394942e7` FOREIGN KEY (`polymer_id`) REFERENCES `polymer_polymer` (`id`);
ALTER TABLE `polymer_polymer_banner` ADD CONSTRAINT `polymer_id_refs_id_f44ae76d` FOREIGN KEY (`polymer_id`) REFERENCES `polymer_polymer` (`id`);
ALTER TABLE `polymer_polymer_gadget` ADD CONSTRAINT `polymer_id_refs_id_7588c6ff` FOREIGN KEY (`polymer_id`) REFERENCES `polymer_polymer` (`id`);
CREATE TABLE `polymer_polymercontent` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `polymer_id` integer NOT NULL,
    `rank` integer NOT NULL,
    `content_type` varchar(10) NOT NULL,
    `content_id` varchar(64) NOT NULL
)
;
ALTER TABLE `polymer_polymercontent` ADD CONSTRAINT `polymer_id_refs_id_9b30f384` FOREIGN KEY (`polymer_id`) REFERENCES `polymer_polymer` (`id`);
CREATE TABLE `polymer_polymertab` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `polymer_id` integer NOT NULL,
    `tab_type` integer NOT NULL,
    `enable` bool NOT NULL,
    UNIQUE (`polymer_id`, `tab_type`)
)
;
ALTER TABLE `polymer_polymertab` ADD CONSTRAINT `polymer_id_refs_id_9c476d9c` FOREIGN KEY (`polymer_id`) REFERENCES `polymer_polymer` (`id`);
CREATE INDEX `polymer_polymer_tags_99b03c8f` ON `polymer_polymer_tags` (`polymer_id`);
CREATE INDEX `polymer_polymer_tags_5659cca2` ON `polymer_polymer_tags` (`tag_id`);
CREATE INDEX `polymer_polymer_banner_99b03c8f` ON `polymer_polymer_banner` (`polymer_id`);
CREATE INDEX `polymer_polymer_banner_10f7da87` ON `polymer_polymer_banner` (`homepageoperate_id`);
CREATE INDEX `polymer_polymer_gadget_99b03c8f` ON `polymer_polymer_gadget` (`polymer_id`);
CREATE INDEX `polymer_polymer_gadget_58d1ef6a` ON `polymer_polymer_gadget` (`gadget_id`);
CREATE INDEX `polymer_polymer_ace39855` ON `polymer_polymer` (`wiki_item_id`);
CREATE INDEX `polymer_polymer_9887bc35` ON `polymer_polymer` (`wiki_collect_id`);
CREATE INDEX `polymer_polymercontent_99b03c8f` ON `polymer_polymercontent` (`polymer_id`);
CREATE INDEX `polymer_polymertab_99b03c8f` ON `polymer_polymertab` (`polymer_id`);

ALTER TABLE `api_gmhome_sideskidcategory` ADD `polymer_id` integer;
CREATE INDEX `api_gmhome_sideskidcategory_99b03c8f` ON `api_gmhome_sideskidcategory` (`polymer_id`);
ALTER TABLE `api_gmhome_sideskidcategory` ADD CONSTRAINT `polymer_id_refs_id_6418e62f` FOREIGN KEY (`polymer_id`) REFERENCES `polymer_polymer` (`id`);

COMMIT;
