-- Deploy gaia:talos_add_user_and_userbzinfo to mysql

BEGIN;

CREATE TABLE `talos_user` (
    `id` integer NOT NULL PRIMARY KEY,
    `person_id` char(32) NOT NULL,
    `nickname` varchar(64),
    `portrait` varchar(128),
    `topic_count` integer,
    `vote_count` integer,
    `membership_level` varchar(1) NOT NULL,
    `city_id` varchar(40),
    `city_tag_id` integer,
    `city_name` varchar(32),
    `province_tag_id` integer,
    `country_tag_id` integer,
    `added_at` datetime(6) NOT NULL
)
;
CREATE TABLE `talos_user_bz_info` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `doctor_id` varchar(100) NOT NULL,
    `doctor_hospital_id` varchar(100) NOT NULL,
    `doctor_type` varchar(1) NOT NULL,
    `added_at` datetime(6) NOT NULL
)
;
ALTER TABLE `talos_user_bz_info` ADD CONSTRAINT `user_id_refs_id_dd4abee8` FOREIGN KEY (`user_id`) REFERENCES `talos_user` (`id`);
CREATE INDEX `talos_user_9d826db6` ON `talos_user` (`person_id`);
CREATE INDEX `talos_user_bz_info_6340c63c` ON `talos_user_bz_info` (`user_id`);
CREATE INDEX `talos_user_bz_info_3505b1b3` ON `talos_user_bz_info` (`doctor_id`);

COMMIT;
