-- Deploy gaia:yd_create to mysql

BEGIN;

-- 医生报名表.
CREATE TABLE `api_youngdoctor_registrationer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `award_id` int(11) NOT NULL,
  `doctor_id` varchar(100) NOT NULL,
  `vote_count` int(11) NOT NULL,
  `final_count` int(11) NOT NULL,
  `doctor_type` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `doctor_id_refs_id_2fb29a5d` (`doctor_id`),
  KEY `yd_award_index` (`award_id`),
  CONSTRAINT `doctor_id_refs_id_2fb29a5d` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 用户投票表
CREATE TABLE `api_youngdoctor_vote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `registrationer_id` int(11) NOT NULL,
  `user_id` varchar(32) NOT NULL,
  `user_type` int(11) NOT NULL,
  `day` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `registrationer_id_refs_id_62682c4d` (`registrationer_id`),
  KEY `yd_vote_day_idx` (`day`),
  KEY `yd_voter_index` (`user_id`),
  CONSTRAINT `registrationer_id_refs_id_62682c4d` FOREIGN KEY (`registrationer_id`) REFERENCES `api_youngdoctor_registrationer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

COMMIT;
