# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function


class Box(object):

    def __init__(self, value=None):
        self.value = value

    def __lshift__(self, other):
        self.value = other

    def __invert__(self):
        return self.value

    def __imul__(self, other):
        self.value = other(self.value)


class Position(object):

    def __init__(self, line, column):
        assert isinstance(line, int)
        assert isinstance(column, int)
        self.line = line
        self.column = column

    def __str__(self):
        return "{}:{}".format(self.line, self.column)


class ParsingException(Exception):

    def __init__(self, position, message):
        super(ParsingException, self).__init__("[{}]{}".format(str(position), message))
        self.position = position
        self.message = message

