# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function


from . import basic
from .basic import SimpleType


class Null(SimpleType):

    def contains(self, item):
        return item is None


class Boolean(SimpleType):

    def contains(self, item):
        return isinstance(item, bool)


class Integer(SimpleType):

    def contains(self, item):
        return isinstance(item, (int, long))


class Real(SimpleType):

    def contains(self, item):
        return isinstance(item, (int, long, float))


class String(SimpleType):

    def contains(self, item):
        return isinstance(item, basestring)

