# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from talos.services.user import UserService

from .topic import Problem


class ProblemFavor(models.Model):
    class Meta:
        unique_together = ("user_id", "problem")
        app_label = 'talos'
        db_table = 'api_problemfavor'

    user_id = models.IntegerField(help_text=u'收藏的用户外键id')
    problem = models.ForeignKey(Problem, related_name="favor_problem", help_text=u"收藏的问题")
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u"收藏时间")
    is_deleted = models.BooleanField(default=False, help_text=u"是否已经删除")

    @property
    def user(self):
        return UserService.get_user_by_user_id(self.user_id)
