# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from talos.services.user import UserService

from .topic import Problem


class TopicScore(models.Model):
    class Meta:
        unique_together = ('topic', 'user_id')
        app_label = 'talos'
        db_table = 'api_topicscore'

    topic = models.ForeignKey(Problem, verbose_name=u'话题', related_name='topic_score')
    user_id = models.IntegerField(verbose_name=u'用户外键id')
    score = models.IntegerField(verbose_name=u'分数', null=True, blank=True)
    last_modified = models.DateTimeField(auto_now=True, verbose_name=u'最后更新时间')

    @property
    def user(self):
        return UserService.get_user_by_user_id(self.user_id)
