# -*- coding: utf8 -*-

from __future__ import unicode_literals, absolute_import, print_function

from talos.libs.utils import ObjFromDict
from talos.backbone.rpc import get_gaia_local_invoker


def get_share_by_share_id(id):
    if not id:
        return

    r = get_gaia_local_invoker()

    try:
        result = r['api/share/by_id'](id=id).unwrap()
    except Exception:
        return None

    return ObjFromDict(result)


def get_location_tag_id_by_city_id(city_id):
    if not city_id:
        return None, None

    r = get_gaia_local_invoker()
    try:
        result = r['api/city/city_and_country_tag_id'](city_id=city_id).unwrap()
    except Exception:
        return None, None
    return result


def get_province_info_by_province_id(province_id):
    r = get_gaia_local_invoker()
    try:
        result = r['api/province/info'](id=province_id).unwrap()
    except Exception:
        return None
    return ObjFromDict(result)


def add_points(reason_type):
    r = get_gaia_local_invoker()
    res = r['api/pointsinfo/add'](reason_type=reason_type).unwrap()
    return res['points']
