# -*- coding:utf-8 -*-

'''
微信关系存储, 不涉及更美账户
'''

from django.db import models

from ..base_model import BaseModel


from gm_types.gaia import WECHAT_PLATFORM_TYPE


class WechatAccountRelation(BaseModel):
    '''
    union-openid关系对应表
    '''
    class Meta:
        verbose_name = '微信各平台open_id记录表'
        app_label = 'api'
        db_table = 'api_wechat_account_relation'

    user_id = models.BigIntegerField(verbose_name='用户id', null=False)
    wechat_platform_type = models.SmallIntegerField(verbose_name='平台类型', choices=WECHAT_PLATFORM_TYPE,
                                             default=WECHAT_PLATFORM_TYPE.GM_SMALL)
    unionid = models.CharField(max_length=60, verbose_name='unionid', null=False)
    openid = models.CharField(max_length=60, verbose_name='openid', null=False)