from api.models import MotherWord, BeautyPhoto, MotherwordPhotoRelated


class WordService(object):
    @classmethod
    def word_parent_info(cls, word_parent_id=None, name=None):
        if not word_parent_id and not name:
            return {}

        obj = None
        if word_parent_id:
            obj = MotherWord.objects.filter(id=word_parent_id, is_online=True).first()
        else:
            obj = MotherWord.objects.filter(name=name, is_online=True).first()

        if not obj:
            return {}

        return {
            'id': obj.id,
            'name': obj.name,
            'gender': obj.gender,
            'content_ad': obj.content_ad,
        }

    @classmethod
    def get_word_by_beauty_photo(cls, url=None, beauty_photo_id=None):
        data = {
            'id': '',
            'name': '',
            'gender': '',
            'content_ad': '',
        }
        if not any([url, beauty_photo_id]):
            return data

        beauty_photo = {}
        if url:
            photo = BeautyPhoto.objects.filter(url=url, is_online=True).first()
            if photo:
                beauty_photo = MotherwordPhotoRelated.objects.select_related(
                    'motherword').filter(beautyphoto_id=photo.id).first()
        elif beauty_photo_id:
            beauty_photo = MotherwordPhotoRelated.objects.select_related(
                'motherword').filter(beautyphoto_id=beauty_photo_id).first()

        if not beauty_photo:
            return data

        return {
            'id': beauty_photo.motherword.id,
            'name': beauty_photo.motherword.name,
            'gender': beauty_photo.motherword.gender,
            'content_ad': beauty_photo.motherword.content_ad,
        }
