from __future__ import print_function
from django.core.management import BaseCommand
from django.contrib.auth.models import User

import xlrd


class Command(BaseCommand):

    def add_arguments(self, parser):
        parser.add_argument('-f', '--file', help="The path of excel to parse.")

    def handle(self, *args, **options):
        excel = options['file']
        book = xlrd.open_workbook(excel)
        for s in book.sheets():
            for row in range(s.nrows):
                values = []
                for col in range(s.ncols):
                    username = s.cell(row, col).value
                    try:
                        userid = User.objects.get(username=username)
                    except User.DoesNotExist:
                        userid = None
                    values.append("%s:%s" % (userid, username))
                print(','.join(values))
        print()

