# coding=utf-8
from datetime import datetime
from django.core.management import BaseCommand
from django.db.models import F
from gm_types.point import ACTIVITY_TYPE

from point.models.mall import PointActivityGoods, PointGoods, PointActivity


def update_placeholder():
    """
    更新大转盘坑位
    之前默认是6个坑，现在更新为8个
    :return:
    """
    PointActivity.objects.filter(
        start_time__lte=datetime.now,
        end_time__gte=datetime.now,
        is_online=True,
        activity_type=ACTIVITY_TYPE.LOTTERY
    ).update(placeholder=8)


def create_pointgood_data():
    ret_id_list = list()
    data_list = [
        {
            'name': u'谢谢参与',
            'describe': u'感谢您的参与',
            'thumb': 'https://heras.igengmei.com/special/2018/10/30/a1dad809a0',
            'image': 'https://heras.igengmei.com/special/2018/10/30/c83ecf29ff',
            'goods_type': 'thsjoin',
            'comment': u'感谢您的参与'
        },
        {
            'name': u'再抽一次',
            'describe': u'恭喜您获得再抽一次机会',
            'thumb': 'https://heras.igengmei.com/special/2018/10/30/c83ecf29ff',
            'image': 'https://heras.igengmei.com/special/2018/10/30/c83ecf29ff',
            'goods_type': 'oneagain',
            'comment': u'恭喜您获得再抽一次机会'
        },
    ]
    for data in data_list:
        p, created = PointGoods.objects.get_or_create(**data)
        ret_id_list.append(p.id)
    return ret_id_list


def create_pointgoodsactivity_data(data_list):
    for data in data_list:
        PointActivityGoods.objects.get_or_create(**data)


def calc_pointgoodsactivity_order(pag_queryset):
    thsjoin_order, oneagain_order = 0, 0
    count_total_weight = sum(pag_queryset.values_list('weight', flat=True)[0:6])
    if pag_queryset.count() > 6:
        thsjoin_order = pag_queryset[5].order
        oneagain_order = pag_queryset[6].order
    elif pag_queryset.count() == 6:
        thsjoin_order = pag_queryset[5].order
        oneagain_order = pag_queryset[5].order + 1

    return thsjoin_order, oneagain_order, count_total_weight


def insert_data(thsjoin_id, oneagain_id):

    in_effect_activity_id_list = list(PointActivity.objects.filter(
        start_time__lte=datetime.now,
        end_time__gte=datetime.now,
        is_online=True,
        activity_type=ACTIVITY_TYPE.LOTTERY
    ).values_list('id', flat=True))

    for activity_id in in_effect_activity_id_list:
        pagqueset = PointActivityGoods.objects.filter(activity_id=activity_id, is_online=True)
        pagqueset.update(weight=F('weight') * 10)
        thsjoin_order, oneagain_order, count_total_weight = calc_pointgoodsactivity_order(pagqueset.order_by('order'))
        data_list = [
            {
                'stock': 999999,
                'current_stock': 999999,
                'order': oneagain_order,
                'good_id': oneagain_id,
                'activity_id': activity_id,
                'weight': 0.3 * count_total_weight,
                'limit': 999999
            },
            {
                'stock': 999999,
                'current_stock': 999999,
                'order': thsjoin_order,
                'good_id': thsjoin_id,
                'activity_id': activity_id,
                'weight': 0.7 * count_total_weight,
                'limit': 999999
            },
        ]
        create_pointgoodsactivity_data(data_list)


class Command(BaseCommand):
    """
        大转盘数据更新脚本
    """

    def handle(self, *args, **options):
        print('-----------update PointGoods placeholder begin-----------')
        update_placeholder()
        print('-----------create PointGoods placeholder end-----------')

        print('-----------create PointGoods data begin-----------')
        thsjoin_id, oneagain_id = create_pointgood_data()
        print('-----------create PointGoods data end-----------')

        print('-----------create PointActivityGoods data begin-----------')
        insert_data(thsjoin_id, oneagain_id)
        print('-----------create PointActivityGoods data end-----------')
        print u'Done!'
