# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

import redis

from django.conf import settings

doctor_pool = redis.ConnectionPool(**settings.REDIS['doctor'])


class FamousRedisClient(object):
    prefix = ""
    pool = None

    def __init__(self):
        self.client = redis.Redis(connection_pool=self.pool)

    def _get_key(self, key):
        return self.prefix + ":" + key

    def increase(self, key):
        key = self._get_key(key)
        self.client.incr(key)

    def incrby(self, key, number):
        key = self._get_key(key)
        self.client.incrby(key, number)

    def get(self, key):
        key = self._get_key(key)
        return self.client.get(key)


class FamousDoctorClient(FamousRedisClient):
    prefix = "famous_doctors"
    pool = doctor_pool

    def get(self, key):
        key = self._get_key(key)
        return self.client.get(key) or 0

    def set(self, key, number):
        self.client.set(self._get_key(key), number)
