-- Deploy gaia:user_1647_coupon to mysql

BEGIN;

CREATE TABLE `api_coupondoctorrestrict` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `coupon_id` integer NOT NULL,
    `doctor_id` varchar(100) NOT NULL,
    UNIQUE (`coupon_id`, `doctor_id`)
)
;
ALTER TABLE `api_coupondoctorrestrict` ADD CONSTRAINT `coupon_id_refs_id_8aafe57d` FOREIGN KEY (`coupon_id`) REFERENCES `api_coupon` (`id`);
ALTER TABLE `api_coupondoctorrestrict` ADD CONSTRAINT `doctor_id_refs_id_13d4a8cc` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);


CREATE TABLE `api_couponspecialrestrict` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `coupon_id` integer NOT NULL,
    `special_id` integer NOT NULL,
    UNIQUE (`coupon_id`, `special_id`)
)
;
ALTER TABLE `api_couponspecialrestrict` ADD CONSTRAINT `coupon_id_refs_id_b41dea5f` FOREIGN KEY (`coupon_id`) REFERENCES `api_coupon` (`id`);
ALTER TABLE `api_couponspecialrestrict` ADD CONSTRAINT `special_id_refs_id_2d98917f` FOREIGN KEY (`special_id`) REFERENCES `api_special` (`id`);


ALTER TABLE `api_coupongift` ADD (
`created_time` datetime(6),
`updated_time` datetime(6),
`start_time` datetime(6),
`end_time` datetime(6),
`memo` longtext NOT NULL);


ALTER TABLE `api_coupon` ADD (
`is_doctor_new` bool NOT NULL,
`discount_limit` bool NOT NULL,
`has_threshold` bool NOT NULL,
`prepay_threshold` integer NOT NULL,
`seckill_avail` bool NOT NULL,
`created_time` datetime(6),
`updated_time` datetime(6),
`activated_time` datetime(6),
`time_type` integer NOT NULL,
`countdown` integer NOT NULL);

ALTER TABLE `api_coupon` MODIFY `start_time` datetime(6);
ALTER TABLE `api_coupon` MODIFY `end_time` datetime(6);


CREATE TABLE `api_channelgift` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `gift_id` integer NOT NULL,
    `business_channel_id` integer NOT NULL,
    `total` integer NOT NULL,
    `limit` integer NOT NULL,
    `activated_time` datetime(6),
    UNIQUE (`gift_id`, `business_channel_id`)
)
;
ALTER TABLE `api_channelgift` ADD CONSTRAINT `business_channel_id_refs_id_22c4ad36` FOREIGN KEY (`business_channel_id`) REFERENCES `api_business_channel` (`id`);
ALTER TABLE `api_channelgift` ADD CONSTRAINT `gift_id_refs_id_a87401c8` FOREIGN KEY (`gift_id`) REFERENCES `api_coupongift` (`id`);

CREATE TABLE `api_giftchannellaunch` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `total` integer NOT NULL,
    `launch_time` datetime(6) NOT NULL,
    `operator_id` integer NOT NULL,
    `channel_gift_id` integer NOT NULL
)
;
ALTER TABLE `api_giftchannellaunch` ADD CONSTRAINT `channel_gift_id_refs_id_2c41dc4c` FOREIGN KEY (`channel_gift_id`) REFERENCES `api_channelgift` (`id`);
ALTER TABLE `api_giftchannellaunch` ADD CONSTRAINT `operator_id_refs_id_2e59d307` FOREIGN KEY (`operator_id`) REFERENCES `auth_user` (`id`);


CREATE TABLE `api_channelgiftuserrelation` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `code` varchar(16) UNIQUE,
    `claimed_time` datetime(6),
    `created_time` datetime(6) NOT NULL,
    `user_id` integer,
    `channel_gift_id` integer NOT NULL,
    `launch_id` integer
)
;
ALTER TABLE `api_channelgiftuserrelation` ADD CONSTRAINT `user_id_refs_id_b22c3842` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_channelgiftuserrelation` ADD CONSTRAINT `channel_gift_id_refs_id_9e3a343f` FOREIGN KEY (`channel_gift_id`) REFERENCES `api_channelgift` (`id`);
ALTER TABLE `api_channelgiftuserrelation` ADD CONSTRAINT `launch_id_refs_id_235621fd` FOREIGN KEY (`launch_id`) REFERENCES `api_giftchannellaunch` (`id`);


ALTER TABLE `api_couponinfo` ADD (
`start_time` datetime(6),
`end_time` datetime(6),
`relation_id` integer);
ALTER TABLE `api_couponinfo` ADD CONSTRAINT `relation_id_refs_id_ceb17fdf` FOREIGN KEY (`relation_id`) REFERENCES `api_channelgiftuserrelation` (`id`);


ALTER TABLE `api_coupongift` MODIFY `channel` INTEGER;
ALTER TABLE `api_coupongift` MODIFY `total` INTEGER;
ALTER TABLE `api_coupongift` MODIFY `launch_time` datetime(6);
ALTER TABLE `api_coupongift` MODIFY `operator_id` INTEGER;

ALTER TABLE `api_couponinfo`  MODIFY `value` INTEGER;
ALTER TABLE `api_couponinfo` MODIFY `channel` INTEGER;

ALTER TABLE `api_business_channel` ADD (
    `memo` LONGTEXT NOT NULL,
    `activated_time` DATETIME(6),
    `created_time` DATETIME(6) NOT NULL
);

COMMIT;
