# coding=utf-8
# create by xueqianqian at 2019/7/8
import tablib
from celery import shared_task
from email.header import make_header

from api.tasks.export_maidan_order_task import get_mail
from hera.utils import attach_title
from hera.utils import get_mail_instance
from rpc.tool.log_tool import log_audit_hera, info_logger


DATETIME_FMT = '%Y-%m-%d %H:%M:%S'


def send_export_mail(subject, body, to_list, dt, send=True):
    if not isinstance(to_list, (list, tuple)):
        to_list = [to_list]
    mail = get_mail_instance(subject, body, to_list)
    mail.attach(attach_title(u'{}.xlsx'.format(subject)), dt.xlsx)
    if send:
        mail.send()

    # audit log
    audit_data = {
        'audit_type': 'export_excel',
        'email_title': subject,
        'email_to': to_list,
        # 'excel_data': dt.xlsx,
        # 'excel_name': u'{}.xlsx'.format(subject),
    }
    log_audit_hera(audit_data)
    return mail


@shared_task
def export_referral_data_excel_task(to_user_email, send_list, order_list, hospital_list, channel_list):
    """
    导出所有转诊数据统计搜索出的数据
    :param to_user_email:
    :return:
    """

    info_logger.info(u'导出开始')
    dt_send = tablib.Dataset()   #派单情况
    dt_order = tablib.Dataset()  #成单情况
    dt_hospital = tablib.Dataset()  #医院情况
    dt_channel = tablib.Dataset()   #渠道情况
    dt_send.headers = (u'人员', u'派单数量', u'派单人数', u'派单医院')
    dt_order.headers = (u'人员', u'成单金额', u'成单抽佣金额', u'成单数', u'成单人数')
    dt_hospital.headers = (u'医院', u'派单数', u'成单数', u'成单金额', u'成单抽佣款金额', u'平均派单业绩', u'平均成单业绩')
    dt_channel.headers = (u'渠道', u'新增线索数', u'派单数', u'成单数',  u'成单金额', u'成单抽佣金额')

    for send in send_list:
        dt_send.append((
            send['single_creator_name'],
            send['send_num'],
            send['send_person'],
            send['send_hospital'],
        ))
    for order in order_list:
        dt_order.append((
            order['single_creator_name'],
            order['budan_projects_payment'],
            order['budan_payment'],
            order['send_num'],
            order['order_num'],
        ))

    for hospital in hospital_list:
        dt_hospital.append((
            hospital['single_doctor_name'],
            hospital['send_num'],
            hospital['order_num'],
            hospital['budan_projects_payment'],
            hospital['budan_payment'],
            hospital['send_achievement'],
            hospital['order_achievement'],
        ))

    for channel in channel_list:
        dt_channel.append((
            channel['channel'],
            channel['clue_num'],
            channel['send_num'],
            channel['order_num'],
            channel['budan_projects_payment'],
            channel['budan_payment'],
        ))

    dt_send.title = u'派单情况'
    dt_order.title = u'成单情况'
    dt_hospital.title = u'医院情况'
    dt_channel.title = u'渠道情况'
    body = ''
    book = tablib.Databook((dt_send, dt_order, dt_hospital, dt_channel))
    info_logger.info(u'导出结束')
    file_name = make_header([('导出转诊数据统计', 'utf-8')]).encode('utf-8')
    get_mail(file_name, body, to_user_email, book).send()

@shared_task
def export_clue_data_excel_task(to_user_email, send_list):
    """
    导出所有线索数据统计搜索出的数据
    :param to_user_email:
    :return:
    """

    info_logger.info(u'导出开始')
    dt = tablib.Dataset()
    dt.headers = (u'人员', u'创建线索数', u'已通过微信验证数', u'未通过微信验证数')

    for send in send_list:
        dt.append((
            send['bdtransfer_creator_name'],
            send['clue_num'],
            send['adopted'],
            send['notadopted'],
        ))

    body = ''
    info_logger.info(u'导出结束')
    file_name = make_header([('导出线索数据统计', 'utf-8')]).encode('utf-8')
    get_mail(file_name, body, to_user_email, dt).send()
