# coding:utf-8
"""
__author__ = 'xumingming'
"""
from django.db import models
from gm_types.gaia import SEARCH_KEYWORDS_TYPE

from api.models import Province


class WordsRecomend(models.Model):
    class Meta:
        verbose_name = '搜索词推荐'
        app_label = 'doris'
        unique_together = ('date', 'province_id', 'tab')

    create_date = models.DateField(auto_now=True)
    date = models.DateField()
    province_id = models.CharField(max_length=120, verbose_name=u'省份ID')
    tab = models.CharField(max_length=20, verbose_name=u'tab类型', choices=SEARCH_KEYWORDS_TYPE)
    words = models.TextField(verbose_name=u'推荐词列表')
