-- Deploy gaia:2019_04_08_add_category_tables to mysql

BEGIN;
CREATE TABLE `category_group` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `polymer_id` integer,
    `s_title` varchar(128) NOT NULL,
    `b_title` varchar(128) NOT NULL,
    `img` varchar(255) NOT NULL,
    `start_time` datetime(6),
    `end_time` datetime(6)
)
;
ALTER TABLE `category_group` ADD CONSTRAINT `polymer_id_refs_id_5e2417b8` FOREIGN KEY (`polymer_id`) REFERENCES `polymer_polymer` (`id`);
CREATE TABLE `category_polymer` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `search_word` varchar(128) NOT NULL,
    `user_type` varchar(2) NOT NULL,
    `payment_type` varchar(2) NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL
)
;
CREATE TABLE `category_area` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `style` smallint NOT NULL
)
;
CREATE TABLE `category_element` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `name` varchar(128) NOT NULL,
    `icon` varchar(255) NOT NULL,
    `background_img` varchar(255) NOT NULL,
    `pre_background_img` varchar(255) NOT NULL,
    `is_main_category` bool NOT NULL,
    `category_type` smallint NOT NULL
)
;
CREATE TABLE `category_polymer_group` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `category_id` integer NOT NULL,
    `group_id` integer NOT NULL
)
;
ALTER TABLE `category_polymer_group` ADD CONSTRAINT `group_id_refs_id_76d70bd5` FOREIGN KEY (`group_id`) REFERENCES `category_group` (`id`);
ALTER TABLE `category_polymer_group` ADD CONSTRAINT `category_id_refs_id_5dcb6fd4` FOREIGN KEY (`category_id`) REFERENCES `category_polymer` (`id`);
CREATE TABLE `category_polymer_banner` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `category_id` integer NOT NULL,
    `banner_id` integer NOT NULL
)
;
ALTER TABLE `category_polymer_banner` ADD CONSTRAINT `banner_id_refs_id_866182d7` FOREIGN KEY (`banner_id`) REFERENCES `api_slide` (`id`);
ALTER TABLE `category_polymer_banner` ADD CONSTRAINT `category_id_refs_id_4c9d50d4` FOREIGN KEY (`category_id`) REFERENCES `category_polymer` (`id`);
CREATE TABLE `category_polymer_area` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `category_id` integer NOT NULL,
    `area_id` integer NOT NULL
)
;
ALTER TABLE `category_polymer_area` ADD CONSTRAINT `category_id_refs_id_e4581aa4` FOREIGN KEY (`category_id`) REFERENCES `category_polymer` (`id`);
ALTER TABLE `category_polymer_area` ADD CONSTRAINT `area_id_refs_id_41a64909` FOREIGN KEY (`area_id`) REFERENCES `category_area` (`id`);
CREATE TABLE `category_area_element` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `area_id` integer NOT NULL,
    `element_id` integer NOT NULL
)
;
ALTER TABLE `category_area_element` ADD CONSTRAINT `area_id_refs_id_a8a6b3d2` FOREIGN KEY (`area_id`) REFERENCES `category_area` (`id`);
ALTER TABLE `category_area_element` ADD CONSTRAINT `element_id_refs_id_9932055a` FOREIGN KEY (`element_id`) REFERENCES `category_element` (`id`);
CREATE TABLE `category_element_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `element_id` integer NOT NULL,
    `tag_id` integer NOT NULL
)
;
ALTER TABLE `category_element_tag` ADD CONSTRAINT `element_id_refs_id_42edd889` FOREIGN KEY (`element_id`) REFERENCES `category_element` (`id`);
ALTER TABLE `category_element_tag` ADD CONSTRAINT `tag_id_refs_id_2a9655df` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
CREATE TABLE `category_polymer_brand` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `category_id` integer NOT NULL,
    `brand_id` integer NOT NULL
)
;
ALTER TABLE `category_polymer_brand` ADD CONSTRAINT `category_id_refs_id_cd421593` FOREIGN KEY (`category_id`) REFERENCES `category_polymer` (`id`);
ALTER TABLE `category_polymer_brand` ADD CONSTRAINT `brand_id_refs_id_fd4df264` FOREIGN KEY (`brand_id`) REFERENCES `wiki_brand` (`id`);
CREATE TABLE `category_polymer_gadget` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `category_id` integer NOT NULL,
    `gadget_id` integer
)
;
ALTER TABLE `category_polymer_gadget` ADD CONSTRAINT `category_id_refs_id_644e6707` FOREIGN KEY (`category_id`) REFERENCES `category_polymer` (`id`);
ALTER TABLE `category_polymer_gadget` ADD CONSTRAINT `gadget_id_refs_id_79f02143` FOREIGN KEY (`gadget_id`) REFERENCES `api_gadget` (`id`);
CREATE TABLE `category_polymer_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `category_id` integer NOT NULL,
    `tag_id` integer
)
;
ALTER TABLE `category_polymer_tag` ADD CONSTRAINT `category_id_refs_id_45cb79f0` FOREIGN KEY (`category_id`) REFERENCES `category_polymer` (`id`);
ALTER TABLE `category_polymer_tag` ADD CONSTRAINT `tag_id_refs_id_abb4279b` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
CREATE TABLE `category_polymer_recommend` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `categorypolymer_id` integer NOT NULL,
    `rank` integer NOT NULL,
    `content_type` varchar(30) NOT NULL,
    `content_id` varchar(64) NOT NULL,
    `start_time` datetime(6),
    `end_time` datetime(6),
    `is_related_city` bool NOT NULL
)
;
ALTER TABLE `category_polymer_recommend` ADD CONSTRAINT `categorypolymer_id_refs_id_7c77416d` FOREIGN KEY (`categorypolymer_id`) REFERENCES `category_polymer` (`id`);
CREATE TABLE `category_polymer_recommend_cities` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `is_deleted` bool NOT NULL,
    `categorypolymerrecommend_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL
)
;
ALTER TABLE `category_polymer_recommend_cities` ADD CONSTRAINT `categorypolymerrecommend_id_refs_id_3416dbb0` FOREIGN KEY (`categorypolymerrecommend_id`) REFERENCES `category_polymer_recommend` (`id`);
ALTER TABLE `category_polymer_recommend_cities` ADD CONSTRAINT `city_id_refs_id_c15564b6` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
CREATE INDEX `category_group_c3bd43a2` ON `category_group` (`update_time`);
CREATE INDEX `category_group_99b03c8f` ON `category_group` (`polymer_id`);
CREATE INDEX `category_polymer_c3bd43a2` ON `category_polymer` (`update_time`);
CREATE INDEX `category_area_c3bd43a2` ON `category_area` (`update_time`);
CREATE INDEX `category_element_c3bd43a2` ON `category_element` (`update_time`);
CREATE INDEX `category_polymer_group_c3bd43a2` ON `category_polymer_group` (`update_time`);
CREATE INDEX `category_polymer_group_6f33f001` ON `category_polymer_group` (`category_id`);
CREATE INDEX `category_polymer_group_5f412f9a` ON `category_polymer_group` (`group_id`);
CREATE INDEX `category_polymer_banner_c3bd43a2` ON `category_polymer_banner` (`update_time`);
CREATE INDEX `category_polymer_banner_6f33f001` ON `category_polymer_banner` (`category_id`);
CREATE INDEX `category_polymer_banner_5f36a279` ON `category_polymer_banner` (`banner_id`);
CREATE INDEX `category_polymer_area_c3bd43a2` ON `category_polymer_area` (`update_time`);
CREATE INDEX `category_polymer_area_6f33f001` ON `category_polymer_area` (`category_id`);
CREATE INDEX `category_polymer_area_a4563695` ON `category_polymer_area` (`area_id`);
CREATE INDEX `category_area_element_c3bd43a2` ON `category_area_element` (`update_time`);
CREATE INDEX `category_area_element_a4563695` ON `category_area_element` (`area_id`);
CREATE INDEX `category_area_element_00a8885a` ON `category_area_element` (`element_id`);
CREATE INDEX `category_element_tag_c3bd43a2` ON `category_element_tag` (`update_time`);
CREATE INDEX `category_element_tag_00a8885a` ON `category_element_tag` (`element_id`);
CREATE INDEX `category_element_tag_5659cca2` ON `category_element_tag` (`tag_id`);
CREATE INDEX `category_polymer_brand_c3bd43a2` ON `category_polymer_brand` (`update_time`);
CREATE INDEX `category_polymer_brand_6f33f001` ON `category_polymer_brand` (`category_id`);
CREATE INDEX `category_polymer_brand_5afadb1e` ON `category_polymer_brand` (`brand_id`);
CREATE INDEX `category_polymer_gadget_c3bd43a2` ON `category_polymer_gadget` (`update_time`);
CREATE INDEX `category_polymer_gadget_6f33f001` ON `category_polymer_gadget` (`category_id`);
CREATE INDEX `category_polymer_gadget_58d1ef6a` ON `category_polymer_gadget` (`gadget_id`);
CREATE INDEX `category_polymer_tag_c3bd43a2` ON `category_polymer_tag` (`update_time`);
CREATE INDEX `category_polymer_tag_6f33f001` ON `category_polymer_tag` (`category_id`);
CREATE INDEX `category_polymer_tag_5659cca2` ON `category_polymer_tag` (`tag_id`);
CREATE INDEX `category_polymer_recommend_c3bd43a2` ON `category_polymer_recommend` (`update_time`);
CREATE INDEX `category_polymer_recommend_f15a8f65` ON `category_polymer_recommend` (`categorypolymer_id`);
CREATE INDEX `category_polymer_recommend_cities_c3bd43a2` ON `category_polymer_recommend_cities` (`update_time`);
CREATE INDEX `category_polymer_recommend_cities_76619acc` ON `category_polymer_recommend_cities` (`categorypolymerrecommend_id`);
CREATE INDEX `category_polymer_recommend_cities_b376980e` ON `category_polymer_recommend_cities` (`city_id`);

COMMIT;