# coding=utf-8
from django.db import models
from api.models import User

class JpushBindUser(models.Model):
    class Meta:
        verbose_name = u'极光绑定医生关系'
        verbose_name_plural = u'极光绑定医生关系'

    user = models.ForeignKey(User, related_name='doctor_jpush_user')
    registration_id = models.CharField(max_length=100, verbose_name=u'jpush-id', db_index=True)
    created_at = models.DateTimeField(auto_now_add=True, verbose_name=u'绑定时间')

    def store(self, *args, **kwargs):
        try:
            object = JpushBindUser.objects.get(registration_id=self.registration_id)
            object.user = self.user
            object.save()
        except JpushBindUser.DoesNotExist:
            JpushBindUser.objects.create(user=self.user, registration_id=self.registration_id)
