# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from api.models import Feedback, FeedbackCategory
from gm_types.gaia import FEEDBACK_RELATED_OBJECT_TYPE


class FeedBackDB(DataBuilder):
    def getval_feedbackcategory__title(self, obj):
        return obj.feedbackcategory.title if getattr(obj, 'feedbackcategory', None) else ''

    def getval_user__last_name(self, obj):
        return obj.user.last_name if getattr(obj, 'user', None) else ''


@DB
class FeedBackDQ(DataSQLQuery):
        model = Feedback
        data_model = FeedBackDB


class FeedBackCategoryDB(DataBuilder):
    def getval_related_type(self, obj):
        return FEEDBACK_RELATED_OBJECT_TYPE.getDesc(obj.related_type)


@DB
class FeedBackCategoryDQ(DataSQLQuery):
        model = FeedbackCategory
        data_model = FeedBackCategoryDB
