# 视图与第一版 data source 的对应关系

## 初始化
```python
from api.models import *
from injection.data_sync.impl.event_attach import ddsm
```

## 规范
所有 ddsm.foreign_key_data_relation 但不带 .reversed 的 relation 都可能有性能问题。

这类 data relation 可以出现在 pk_data_source 中，但

*严禁*

出现在 index_data_source 中。


## 单表
```sql
SELECT * from api_service;
```
```python
ddsm.model_data_source(Service)
```

## 简单 Join （包含自身）
```sql
SELECT * from api_service
INNER JOIN api_doctor ON api_service.doctor_id = api_doctor.id
```
形式一
```python
JoinedDataSource(
    ddsm.model_data_source(Service),
    ddsm.model_data_source(Doctor),
    ddsm.foreign_key_data_relation(Service.doctor.field),
)
```
形式二
```python
GroupedDataSource(
    ddsm.model_data_source(Service),
    RelatedDataSource(
        ddsm.model_data_source(Service),
        ddsm.model_data_source(Doctor),
        ddsm.foreign_key_data_relation(Service.doctor.field),
    ),
)
```


## 简单 Join （不包含自身）
```sql
SELECT api_service.id, api_doctor.* from api_service
INNER JOIN api_doctor ON api_service.doctor_id = api_doctor.id
```
```python
RelatedDataSource(
    ddsm.model_data_source(Service),
    ddsm.model_data_source(Doctor),
    ddsm.foreign_key_data_relation(Service.doctor.field),
)
```


## 反向 Join （不包含自身）
```sql
SELECT api_service.id, api_order.* from api_service
INNER JOIN api_order ON api_order.service_id = api_service.id
```
```python
RelatedDataSource(
    ddsm.model_data_source(Service),
    ddsm.model_data_source(Order),
    ddsm.foreign_key_data_relation(Order.service.field).reversed,
)
```


## 多表单层 Join
```sql
SELECT * from api_service
INNER JOIN api_doctor ON api_service.doctor_id = api_doctor.id
INNER JOIN api_order ON api_order.service_id = api_service.id
```
```python
GroupedDataSource(
    ddsm.model_data_source(Service),
    RelatedDataSource(
        ddsm.model_data_source(Service),
        ddsm.model_data_source(Doctor),
        ddsm.foreign_key_data_relation(Service.doctor.field),
    ),
    RelatedDataSource(
        ddsm.model_data_source(Service),
        ddsm.model_data_source(Order),
        ddsm.foreign_key_data_relation(Order.service.field).reversed,
    ),
)
```


## 多表多层 Join
```sql
SELECT * from api_service
INNER JOIN api_doctor ON api_service.doctor_id = api_doctor.id
INNER JOIN api_hospital ON api_doctor.hospital_id = api_hospital.id
INNER JOIN api_city ON api_hospital.city_id = api_city.id
INNER JOIN api_order ON api_order.service_id = api_service.id
```
```python
GroupedDataSource(
    ddsm.model_data_source(Service),
    RelatedDataSource(
        ddsm.model_data_source(Service),
        JoinedDataSource(
            ddsm.model_data_source(Doctor),
            JoinedDataSource(
                ddsm.model_data_source(Hospital),
                ddsm.model_data_source(City),
                ddsm.foreign_key_data_relation(Hospital.city.field),
            ),
            ddsm.foreign_key_data_relation(Doctor.hospital.field),
        ),
        ddsm.foreign_key_data_relation(Service.doctor.field),
    ),
    RelatedDataSource(
        ddsm.model_data_source(Service),
        ddsm.model_data_source(Order),
        ddsm.foreign_key_data_relation(Order.service.field).reversed,
    ),
)
```
