-- Deploy gaia:pay_2015_03_14_create_tables_for_doctor_statment to mysql

BEGIN;

CREATE TABLE `pay_statement` (
    `id` varchar(15) NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL,
    `status` integer NOT NULL,
    `original_amount` double precision NOT NULL,
    `settle_amount` double precision NOT NULL,
    `poundage_rate` double precision NOT NULL,
    `created_at` datetime(6) NOT NULL,
    `updated_at` datetime(6) NOT NULL,
    `statement_date` integer NOT NULL,
    `check_snapshot` longtext NOT NULL,
    `settle_snapshot` longtext NOT NULL,
    UNIQUE (`doctor_id`, `statement_date`)
)
;
ALTER TABLE `pay_statement` ADD CONSTRAINT `doctor_id_refs_id_2e8c88c7` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE TABLE `pay_orderstatementrelationship` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `statement_id` varchar(15) NOT NULL,
    `order_id` varchar(12) NOT NULL
)
;
ALTER TABLE `pay_orderstatementrelationship` ADD CONSTRAINT `statement_id_refs_id_4ec7b36a` FOREIGN KEY (`statement_id`) REFERENCES `pay_statement` (`id`);
ALTER TABLE `pay_orderstatementrelationship` ADD CONSTRAINT `order_id_refs_id_290eee05` FOREIGN KEY (`order_id`) REFERENCES `api_order` (`id`);
CREATE TABLE `pay_feededuction` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `statement_id` varchar(15) NOT NULL,
    `value` double precision NOT NULL,
    `comment` varchar(100) NOT NULL
)
;
ALTER TABLE `pay_feededuction` ADD CONSTRAINT `statement_id_refs_id_69bd5584` FOREIGN KEY (`statement_id`) REFERENCES `pay_statement` (`id`);
CREATE TABLE `pay_statementoperation` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `statement_id` varchar(15) NOT NULL,
    `operator_id` char(32),
    `optype` integer NOT NULL,
    `role` integer NOT NULL,
    `operate_at` datetime(6)
)
;
ALTER TABLE `pay_statementoperation` ADD CONSTRAINT `statement_id_refs_id_86baa497` FOREIGN KEY (`statement_id`) REFERENCES `pay_statement` (`id`);
ALTER TABLE `pay_statementoperation` ADD CONSTRAINT `operator_id_refs_id_6bf54891` FOREIGN KEY (`operator_id`) REFERENCES `api_person` (`id`);

COMMIT;
