#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
__title__ = '日记本相关计数'
__author__ = 'xierong@gmei.com'
__mtime__ = '18/1/9'
'''

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from talos.models.diary.diary import Diary


class DiaryExtra(models.Model):
    """
    日记本统计相关
    """

    class Meta:
        verbose_name = u'日记本统计数据表'
        db_table = 'api_diary_extra'
        app_label = 'talos'

    diary = models.OneToOneField(Diary, related_name="extra_info", verbose_name=u'日记本')
    topic_count = models.IntegerField(verbose_name=u'日记帖总数', default=0)
    reply_count = models.IntegerField(verbose_name=u'日记本及日记帖的回复总数', default=0)
    vote_count = models.IntegerField(verbose_name=u'日记本及日记帖的点赞总数', default=0)
    total_pv = models.IntegerField(verbose_name=u'日记本及日记帖的pv', default=0)