# coding=utf-8
from django.core.management import BaseCommand

from api.models import ServiceRegister


class Command(BaseCommand):
    """
    python manage.py serviceregister_set_doctor_can_see
    设置遗留的serviceregister表的数据,置为医生看不到
    """

    def handle(self, *args, **options):
        _file = open('doctor_can_not_see.txt', 'a')
        serviceregisters = ServiceRegister.objects.filter(service__isnull=True, is_register=False)
        print len(serviceregisters)
        for serviceregister in serviceregisters:
            print (serviceregister.id, serviceregister.name)
            serviceregister.doctor_can_see = False
            serviceregister.save()
            message = str(serviceregister.id) + '\n'
            _file.write(message)
        _file.close()
