# -*- coding: utf-8 -*-

from gm_dataquery.db import DB
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery

from api.models.face.facial import Facial, FacialCombi
from api.models.face.nanshen_shouge import NanshenAnswer, NanshenQuestion, NanshenReport, NanshenFaceType, ShareRecord, \
    UnlockRecord
from api.models.face.facial import FacialFeatureFamily
from polymer.models import PolymerTag


class FacialDB(DataBuilder):

    def getval_contour(self, obj):
        return obj.classification

    def getval_chin(self, obj):
        return obj.classification

    def getval_eyebrow(self, obj):
        return obj.classification

    def getval_eye(self, obj):
        return obj.classification

    def getval_nose(self, obj):
        return obj.classification

    def getval_lip(self, obj):
        return obj.classification


@DB
class FacialDQ(DataSQLQuery):
    model = Facial
    data_model = FacialDB


class FacialCombiDB(DataBuilder):
    pass


@DB
class FacialCombiDQ(DataSQLQuery):
    model = FacialCombi
    data_model = FacialCombiDB


class FacialFeatureFamilyDB(DataBuilder):
    def getval_tags(self, obj):
        return list(
            PolymerTag.objects.filter(polymer_id=obj.polymer_id, is_online=True).values_list("tag_id", flat=True))


@DB
class FacialFeatureFamilyDQ(DataSQLQuery):
    model = FacialFeatureFamily
    data_model = FacialFeatureFamilyDB


class NanshenAnswerDB(DataBuilder):
    pass

@DB
class NanshenAnswerDQ(DataSQLQuery):
    model = NanshenAnswer
    data_model = NanshenAnswerDB


class NanshenQuestionDB(DataBuilder):
    pass


@DB
class NanshenQuestionDQ(DataSQLQuery):
    model = NanshenQuestion
    data_model = NanshenQuestionDB


class NanshenReportDB(DataBuilder):
    pass


@DB
class NanshenReportDQ(DataSQLQuery):
    model = NanshenReport
    data_model = NanshenReportDB


class NanshenFaceTypeDB(DataBuilder):
    pass


@DB
class NanshenFaceTypeDQ(DataSQLQuery):
    model = NanshenFaceType
    data_model = NanshenFaceTypeDB


class ShareRecordDB(DataBuilder):
    pass


@DB
class ShareRecordDQ(DataSQLQuery):
    model = ShareRecord
    data_model = ShareRecordDB


class UnlockRecordDB(DataBuilder):
    pass


@DB
class UnlockRecordDQ(DataSQLQuery):
    model = UnlockRecord
    data_model = UnlockRecordDB
