# coding=utf-8
import traceback
import logging
from .es import tzlc
from answer.models.answer import Answer
from talos.models.diary.diary import Diary, Problems
from talos.models.topic.video import Video
from talos.models.topic.topicimage import TopicImage
from talos.models.tractate import TractateImages, TractateVideo, Tractate, VideoCover
from answer.models.answer import AnswerImage


def get_user_album(instance):
    # alias
    u = instance

    res = dict()
    res["id"] = u.id
    res["album"] = get_user_album_data(u.id)

    return res


def get_user_album_data(user_id):
    try:
        all_data = []

        # 获取日记的视频和相册
        # 此处还没有获取type  1
        diary_data = Problems.objects.filter(is_online=True, user_id=user_id, topic_type__in=["0", "1", "2"]).values(
            "id", "created_time")
        for item in diary_data:
            diaryimage = TopicImage.objects.filter(topic_id=item.get("id", None)).values_list("image_url",
                                                                                              flat=True).first()
            diaryvideo = Video.objects.filter(topic_id=item.get("id", None)).values_list("video_url", flat=True).first()

            if diaryimage or diaryvideo:
                item_data = {}
                item_data["type"] = 1
                item_data["create_time"] = tzlc(item["created_time"])
                item_data["id"] = item["id"]
                all_data.append(item_data)

        # 获取用户帖的视频和相册
        # 此处还没有获取type  2
        tractate_data = Tractate.objects.filter(is_online=True, user_id=user_id).values("id", "create_time")

        for item in tractate_data:
            tractatevideo = TractateVideo.objects.filter(tractate_id=item.get("id", None)).values_list(
                "video_cover_url", flat=True).first()
            tractateimage = TractateImages.objects.filter(tractate_id=item.get("id", None)).values_list("image_url",
                                                                                                        flat=True).first()
            if tractateimage or tractatevideo:
                item_data = {}
                item_data["type"] = 2
                item_data["create_time"] = tzlc(item["create_time"])
                item_data["id"] = item["id"]
                all_data.append(item_data)

        # 获取问答的视频和相册
        # 此处还没有获取type  3
        answer_data = Answer.objects.filter(user=user_id, is_online=True).values("id", "create_time")
        for item in answer_data:
            answerimage = AnswerImage.objects.filter(answer_id=item.get("id", None)).values_list("image_url",
                                                                                                 flat=True).first()
            answervideo = VideoCover.objects.filter(source_id=item.get("id", None), source_type=2).values_list(
                "video_url", flat=True).first()
            if answerimage or answervideo:
                item_data = {}
                item_data["type"] = 3
                item_data["create_time"] = tzlc(item["create_time"])
                item_data["id"] = item["id"]
                all_data.append(item_data)

        return all_data
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []
