#!/usr/bin/env python
# -*- coding: utf-8 -*-

from agile.services import (
    AgileTagService,
    AgileTagTypeService,
    AgileTagMappingTagService,
    AgileTagRecommendTypeService,
    AgileTagRelationPolymerService,
)


class AgileTagFormat(object):

    @classmethod
    def agile_tags_info_format(cls, agile_tag_ids, simple=True, only_need_old_tag_ids=True):
        """
        新标签数据拼接转换
        :param agile_tag_ids:
        :param simple:
        :param only_need_old_tag_ids:
        :return:
        """
        # 新标签，标签基本数据
        _agile_tags_dic = AgileTagService.get_tag_by_ids(agile_tag_ids, simple=simple)
        # 新标签，标签类型数据
        _agile_tags_type_dic = AgileTagTypeService.get_agile_types(agile_tag_ids)
        # 新标签，标签推荐类型数据
        _agile_tags_recommend_type_dic = AgileTagRecommendTypeService.get_recommend_type_info(agile_tag_ids)

        if simple:  # 如果只是需要简单数据的话
            _agile_tags_mapping_dic = {}
            _agile_tags_polymer = {}
        else:
            # 新标签，标签映射老标签数据
            _agile_tags_mapping_dic = AgileTagMappingTagService.get_mapping_tags_by_agile_tag_ids(
                agile_tag_ids,
                only_need_old_tag_ids=only_need_old_tag_ids
            )
            # 获取对应的聚合页数据
            _agile_tags_polymer = AgileTagRelationPolymerService.get_polymer_id_by_agile_tag_ids(
                agile_tag_ids
            )
        # 数据组装
        _agile_tags = _agile_tags_dic.get("result", [])
        _agile_tags_dic = {}
        for agile_tag in _agile_tags:
            _agile_tag_id = agile_tag.get("id", 0)
            if _agile_tag_id:
                agile_tag.update({
                    "tags_type": _agile_tags_type_dic.get(_agile_tag_id, []),
                    "recommends_type": _agile_tags_recommend_type_dic.get(_agile_tag_id, []),
                    "mapping_old_tag_ids": [],  # 仅有id
                    "mapping_old_tags_info": [],  # 详细数据
                    "polymer_id": _agile_tags_polymer.get(_agile_tag_id, 0)  # 关联的聚合页id
                })

                if only_need_old_tag_ids:
                    agile_tag.update({
                        "mapping_old_tag_ids": _agile_tags_mapping_dic.get(str(_agile_tag_id), []),
                    })
                else:
                    agile_tag.update({
                        "mapping_old_tags_info": _agile_tags_mapping_dic.get(str(_agile_tag_id), [])
                    })

                _agile_tags_dic[str(_agile_tag_id)] = agile_tag

        return _agile_tags_dic
