# coding=utf-8
import hashlib

from django.conf import settings
from django.core.management import BaseCommand
from api.models import Hospital, PeriodHospital


class Command(BaseCommand):
    def handle(self, *args, **options):
        file = open('hospital_list.txt')
        lines = file.readlines()
        for line in lines:
            try:
                line = line.strip()
                hash_id = hashlib.md5(line).hexdigest()
                hospital = Hospital.objects.get(id=line)
                PeriodHospital.objects.get_or_create(hospital=hospital, period_id=hash_id)
            except:
                print (u'bug:' + line)
