# coding=utf-8
import xlwt
from django.core.management import BaseCommand
from api.models import Doctor


def xlwt_write_row(sheet, row_num, data):
    colum_num = 0
    for o in data:
        sheet.write(row_num, colum_num, o)
        colum_num += 1


class Command(BaseCommand):
    """
    导出医生关联商务 12-16
    puthon manage.py export_business_partent
    """

    def handle(self, *args, **options):

        doctors = Doctor.objects.all()
        workbook = xlwt.Workbook()
        sheet = workbook.add_sheet('xx')
        sheet1 = workbook.add_sheet('xx1')
        header = [u'医生ID', u'医生名称', u'医院ID', u'医院名称', u'是否在线', u'关联商务', u'关联商务是否在线']
        xlwt_write_row(sheet, 0, header)
        xlwt_write_row(sheet1, 0, header)
        row = 1
        for doctor in doctors:
            try:
                try:
                    hospital = doctor.hospital
                except Exception as e:
                    print e.message
                    hospital = None

                try:
                    business_partener = doctor.business_partener
                except Exception as e:
                    print e.message
                    business_partener = None

                id = doctor.id
                name = doctor.name
                hosiptal_id = hospital.id if hospital is not None else ''
                hospital_name = hospital.name if hospital is not None else ''
                is_online = doctor.is_online
                username = business_partener.username if business_partener else ''
                is_staff = business_partener.is_staff if business_partener else ''

                sheet.write(row, 0, id)
                sheet.write(row, 1, name)
                sheet.write(row, 2, hosiptal_id)
                sheet.write(row, 3, hospital_name)
                sheet.write(row, 4, is_online)
                sheet.write(row, 5, username)
                sheet.write(row, 6, is_staff)
                row += 1
            except Exception as e:
                row += 1
                print e.message
                continue
        print u'继续'

        # for doctor in doctors[4000:]:
        #     try:
        #         try:
        #             hospital = doctor.hospital
        #         except Exception as e:
        #             print e.message
        #             hospital = None
        #
        #         try:
        #             business_partener = doctor.business_partener
        #         except Exception as e:
        #             print e.message
        #             business_partener = None
        #
        #         id = doctor.id
        #         name = doctor.name
        #         hosiptal_id = hospital.id if hospital is not None else u''
        #         hospital_name = hospital.name if hospital is not None else u''
        #         is_online = doctor.is_online
        #         username = business_partener.username if business_partener else u''
        #         is_staff = business_partener.is_staff if business_partener else u''
        #
        #         sheet1.write(row, 0, id)
        #         sheet1.write(row, 1, name)
        #         sheet1.write(row, 2, hosiptal_id)
        #         sheet1.write(row, 3, hospital_name)
        #         sheet1.write(row, 4, is_online)
        #         sheet1.write(row, 5, username)
        #         sheet1.write(row, 6, is_staff)
        #         row += 1
        #     except Exception as e:
        #         row += 1
        #         print e.message
        #         continue
        # print u'继续'
        workbook.save(u'/data/service/1.xls')
