# coding=utf-8
from django.core.management import BaseCommand

from api.models import CashBackOrder
from gm_types.gaia import PROBLEM_REVIEW_STATUS_CHOICES


class Command(BaseCommand):
    def handle(self, *args, **options):
        cashbacks = CashBackOrder.objects.all()
        fail_ids = []
        for cashback in cashbacks:
            cashback.topic_cash_back_limit = int(cashback.fee / 50) + 1
            try:
                topics = cashback.order.diary.topics.filter(
                    review_status=PROBLEM_REVIEW_STATUS_CHOICES.OK, is_online=True,
                )
                cashback.topic_cash_back_num = topics.count()
                print(cashback.id, cashback.topic_cash_back_limit, cashback.topic_cash_back_num)
            except Exception as e:
                print(e, cashback.id)
                fail_ids.append(cashback.id)
            cashback.save()
        print(fail_ids)
