# coding=utf-8
import hashlib

from django.conf import settings
from django.core.management import BaseCommand
from api.models import Hospital, PeriodHospital


class Command(BaseCommand):
    def handle(self, *args, **options):
        hospitals = Hospital.objects.all()
        for hospital in hospitals:
            try:
                hash_id = hashlib.md5(hospital.id.encode('utf-8')).hexdigest()
            except:
                print (u'bug:' + hospital.id)
            if hash_id in settings.HOSTPITAL_LIST:
                try:
                    PeriodHospital.objects.get_or_create(hospital=hospital, period_id=hash_id)
                    print (u'success' + hospital.id)
                except:
                    print (u'error' + hospital.id)
