# coding:utf-8

from django.core.management import BaseCommand
from gm_upload.utils.qiniu_tool import QiniuTool
from api.models import *
from api.models.consult import ConsultWiki
from api.models.greetpopup import GreetingPopup
from gm_upload import IMG_TYPE
from gm_upload.consts import GmImageManager
from community.models.article import *
from community.models.sticky import *
from doctor.models.capture import *
from doctor.models.content import *
from doctor.models.stats import *
from doctor.models.support import *
from blog.models.post import Post
from blog.models.category import Category

imgcdn = u'http://imgcdn.wanmeizhensuo.com/'
qiniucdn = u'http://wanmeizhensuo.qiniudn.com/'
cdn = u'http://7d9qwy.com2.z0.glb.qiniucdn.com/'
old_cdn = u'http://www.wanmeizhensuo.com/zhengxing/media/images/'


def get_short_path(path_name, host='', extra=''):
    domains = [
        u'http://wanmeizhensuo.qiniudn.com/',
        u'http://imgcdn.wanmeizhensuo.com/',
        u'http://7d9qwy.com2.z0.glb.qiniucdn.com/',
        u'http://hera.s.gengmei.cc/',
        u'http://hera.s.gmei.com/',
    ]
    for domain in domains:
        if domain in path_name:
            short_path = path_name.replace(domain, '')

    # if path_name:
    #     if imgcdn in path_name:
    #         short_path = path_name.replace(imgcdn, '')
    #     elif qiniucdn in path_name:
    #         short_path = path_name.replace(qiniucdn, '')
    #     elif cdn in path_name:
    #         short_path = path_name.replace(cdn, '')
    #     elif old_cdn in path_name:
    #         short_path = path_name.replace(old_cdn, '')
    #     elif settings.QINIU_CDN_HOST in path_name:
    #         short_path = path_name.replace(settings.QINIU_CDN_HOST, '')
    #     else:
    #         short_path = path_name.replace(host, '')
    # else:
    #     short_path = ''
    return short_path + extra


def move_image(model, host, fields, img_type):
    print model
    objs = model.objects.all()
    cnt = objs.count()
    bgn = 0
    step = 1000
    while bgn <= cnt:
        for obj in objs[bgn: bgn + step]:
            prefix = GmImageManager(img_type).get_prefix()
            need_save = False
            for field in fields:
                try:
                    print field, getattr(obj, 'id', '')
                    if not getattr(obj, field):
                        continue
                    origin_key = getattr(obj, field)
                    key = get_short_path(origin_key, host)
                    print key, origin_key
                    ret, info = QiniuTool.bucket.stat('hera', key)
                    if not ret:
                        print 'need copy'
                        QiniuTool.copy(key, key, 'wanmeizhensuo', 'hera')
                    need_save = True
                    setattr(obj, field, key)

                    # new_key = prefix + '/' + key
                    # if QiniuTool.copy(key, new_key, 'wanmeizhensuo', 'hera'):
                    #     setattr(obj, field, new_key)
                    # else:
                    #     print "error:{}{}".format(obj.id, field)
                except Exception as e:
                    print e
            if need_save:
                print '!!need save!!'
                obj.save()
        bgn += step


class Command(BaseCommand):
    def handle(self, *args, **options):
        # move_image(
        #     model=Tag,
        #     host='',
        #     fields=['icon_url'],
        #     img_type=IMG_TYPE.TAG
        # )
        #
        # move_image(
        #     model=Activity,
        #     host='http://7d9qwy.com2.z0.glb.qiniucdn.com/',
        #     fields=['banner'],
        #     img_type=IMG_TYPE.BANNER
        # )
        # move_image(
        #     model=BodyPart,
        #     host='http://www.wanmeizhensuo.com/zhengxing/media/images/',
        #     fields=['image_url', 'index_img_url', 'icon', 'icon_web'],
        #     img_type=IMG_TYPE.BODYPART
        # )
        # move_image(
        #     model=Campaign,
        #     host='',
        #     fields=['banner'],
        #     img_type=IMG_TYPE.BANNER
        # )
        # move_image(
        #     model=CampaignImageLink,
        #     host='',
        #     fields=['image', 'image1'],
        #     img_type=IMG_TYPE.CAMPAIGNIMAGELINK
        # )
        # move_image(
        #     model=CampaignCouponPage,
        #     host='',
        #     fields=['banner'],
        #     img_type=IMG_TYPE.BANNER
        # )
        # move_image(
        #     model=ConsultWiki,
        #     host='',
        #     fields=['icon'],
        #     img_type=IMG_TYPE.CONSULTWIKI
        # )
        # move_image(
        #     model=Doctor,
        #     host='',
        #     fields=['portrait', 'large_photo'],
        #     img_type=IMG_TYPE.DOCTOR
        # )
        # move_image(
        #     model=FeedbackCategory,
        #     host='',
        #     fields=['icon'],
        #     img_type=IMG_TYPE.FEEDBACKCATEGORY
        # )
        # move_image(
        #     model=GreetingPopup,
        #     host='',
        #     fields=['image'],
        #     img_type=IMG_TYPE.GREETINGPOPUP
        # )
        # move_image(
        #     model=Hospital,
        #     host='',
        #     fields=['business_licence', 'practice_licence', 'query_image', 'portrait'],
        #     img_type=IMG_TYPE.HOSPITAL
        # )
        # move_image(
        #     model=ItemWiki,
        #     host='',
        #     fields=['image'],
        #     img_type=IMG_TYPE.ITEMWIKI
        # )
        # move_image(
        #     model=RecommendApp,
        #     host='',
        #     fields=['icon'],
        #     img_type=IMG_TYPE.RECOMMENDAPP
        # )
        # move_image(
        #     model=WebSlide,
        #     host='',
        #     fields=['image'],
        #     img_type=IMG_TYPE.WEBSLIDE
        # )
        # move_image(
        #     model=PushTask,
        #     host='',
        #     fields=['banner'],
        #     img_type=IMG_TYPE.BANNER
        # )
        # move_image(
        #     model=Service,
        #     host='',
        #     fields=['image_header', 'image_detail'],
        #     img_type=IMG_TYPE.SERVICE
        # )
        # move_image(
        #     model=ServiceActivity,
        #     host='',
        #     fields=['image'],
        #     img_type=IMG_TYPE.SERVICEACTIVITY
        # )
        # move_image(
        #     model=Share,
        #     host='',
        #     fields=['image'],
        #     img_type=IMG_TYPE.SHARE
        # )
        # move_image(
        #     model=Slide,
        #     host='',
        #     fields=['slide_img', 'slide_img1'],
        #     img_type=IMG_TYPE.SLIDE
        # )
        # move_image(
        #     model=SmallImage,
        #     host='',
        #     fields=['image'],
        #     img_type=IMG_TYPE.SMALLIMAGE
        # )
        # move_image(
        #     model=Special,
        #     host='',
        #     fields=['image', 'icon'],
        #     img_type=IMG_TYPE.SPECIAL
        # )
        # move_image(
        #     model=Tag,
        #     host='',
        #     fields=['banner_url'],
        #     img_type=IMG_TYPE.TAG
        # )
        # move_image(
        #     model=TagAlertItem,
        #     host='',
        #     fields=['image_url'],
        #     img_type=IMG_TYPE.TAG
        # )
        # move_image(
        #     model=Post,
        #     host='',
        #     fields=['banner_image'],
        #     img_type=IMG_TYPE.POST
        # )
        # move_image(
        #     model=Article,
        #     host='',
        #     fields=['banner'],
        #     img_type=IMG_TYPE.ARTICLE
        # )
        # move_image(
        #     model=DoctorRegister,
        #     host='',
        #     fields=['portrait', 'business_licence', 'practice_licence', 'query_image'],
        #     img_type=IMG_TYPE.DOCTORREGISTER
        # )
        # move_image(
        #     model=HomePopup,
        #     host='',
        #     fields=['image'],
        #     img_type=IMG_TYPE.HOMEPOPUP
        # )
        # move_image(
        #     model=HomeSlide,
        #     host='',
        #     fields=['image'],
        #     img_type=IMG_TYPE.HOMESLIDE
        # )
        # move_image(
        #     model=Bulletin,
        #     host='',
        #     fields=['image'],
        #     img_type=IMG_TYPE.BULLETIN
        # )
        move_image(
            AdvertiseHospital,
            host='',
            fields=['portrait'],
            img_type=IMG_TYPE.ADVERTISE
        )
