#!/usr/bin/env python
# encoding=utf-8

from django.core.management import BaseCommand
from api.models import Diary
from django.db.models import Q
from api.models.types import DIARY_CONTENT_LEVEL


class Command(BaseCommand):

    def handle(self, *args, **options):
        q = Q(is_headline=True) | Q(is_essence=True)
        diarys = Diary.objects.filter(q)
        for diary in diarys.iterator():
            try:
                if diary.is_headline:
                    diary.content_level = DIARY_CONTENT_LEVEL.EXCELLENT
                else:
                    diary.content_level = DIARY_CONTENT_LEVEL.FINE
                print diary.id
                diary.save()
            except Exception as e:
                print str(diary.id) + u":" + e.message
                continue
        print u"DONE!"
