# coding=utf-8

import time
import xlrd

from django.core.management import BaseCommand

from api.models.face.facial import FacialCombi


class Command(BaseCommand):
    @classmethod
    def update_facial_combi(cls, file_path):
        xls_file = xlrd.open_workbook(file_path)
        xls_sheet = xls_file.sheets()[0]

        for line in range(1, xls_sheet.nrows):
            row_value = xls_sheet.row_values(line)
            face_name = row_value[3]
            face_desc = row_value[4]
            face_celebrity = row_value[5]

            obj = FacialCombi.objects.filter(title=face_name, is_online=True).first()
            if obj:
                obj.desc = face_desc
                obj.celebrity = face_celebrity
                obj.save()

    def handle(self, *args, **kwargs):
        time_start = int(time.time() * 1000)

        print('----------开始更新数据-----------------')
        file_path = "./api/management/files/ai_face_info.xlsx"  # args[2]  ai_facial.xlsx
        self.update_facial_combi(file_path)
        print('----------更新数据完成-----------------')
        time_end = int(time.time() * 1000)
        print("----------耗时 {} 毫秒----------------".format(time_end-time_start))



