# coding=utf-8
import random

from gm_types.gaia import FILTER_WORD_TYPE

from api.models import User
from rpc.all import get_rpc_remote_invoker

user_portraits = [
    'http://pic.igengmei.com/user/icon@2x.png',
    'http://pic.igengmei.com/user/icon2@2x.png',
    'http://pic.igengmei.com/user/icon3@2x.png',
    'http://pic.igengmei.com/user/icon4@2x.png',
    'http://pic.igengmei.com/user/icon5@2x.png',
    'http://pic.igengmei.com/user/icon6@2x.png',
    'http://pic.igengmei.com/user/icon7@2x.png',
    'http://pic.igengmei.com/user/icon8@2x.png',
    'http://pic.igengmei.com/user/icon9@2x.png',
    'http://pic.igengmei.com/user/icon10@2x.png',
    'http://pic.igengmei.com/user/icon11@2x.png',
    'http://pic.igengmei.com/user/icon12@2x.png',
    'http://pic.igengmei.com/user/icon13@2x.png',
    'http://pic.igengmei.com/user/icon14@2x.png',
    'http://pic.igengmei.com/user/icon15@2x.png',
]


def valid_nick_name(nick_name):
    filter_word_list = get_rpc_remote_invoker()['talos/filterWord/list'](filter_type=FILTER_WORD_TYPE.USER_NAME)
    filter_word_list = filter_word_list.unwrap()
    if len(nick_name.strip()) > 15:
        return {"error": 4, "message": "昵称请少于15个字:)"}
    elif User.objects.filter(last_name=nick_name).exists():
        return {"error": 2, "message": "该昵称已存在，请换一个试试:)"}
    elif any(word in nick_name for word in filter_word_list):
        return {"error": 5, "message": "该昵称违规，请换一个试试"}
    elif any(keyword in nick_name for keyword in (u'医生', u'大夫', u'医院', u'咨询师', u'整形', u'美容', u'医师', u'血荐轩辕')):
        return {"error": 3, "message": "如果您是整形医生，请返回到个人页面点击【医生加入】，申请加入更美医生专家团队。"}
    else:
        return {'error': 0, 'message': ''}

