# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.contrib.auth.models import User

import json

from gm_types.gaia import HERA_OPERATE_LOG_PACKAGE, HERA_OPERATE_LOG_ACTION


class SimpleActionLog(models.Model):
    class Meta:
        db_table = 'api_hera_audit_simple_action_log'
        index_together = [
            ['package', 'action_time'],
            ['package', 'object_type', 'action_time'],
            ['user', 'package', 'action_time'],
            ['user', 'package', 'object_type', 'action_time'],
        ]
        app_label = 'api'

    action_time = models.DateTimeField(null=False, db_index=True, auto_now_add=True, verbose_name="动作发生的时间")
    user = models.ForeignKey(to=User, null=False, verbose_name="产生动作的用户")
    package = models.CharField(null=False, blank=False, max_length=250, verbose_name="动作所在的包名")
    action = models.CharField(null=False, blank=False, max_length=50, db_index=True, verbose_name="动作名称")

    object_type = models.CharField(db_index=True, null=True, blank=True, max_length=250, verbose_name="动作操作的对象类型")
    object_id_json = models.TextField(null=False, blank=False, verbose_name="动作操作的对象的id (json serialized)")

    message = models.TextField(null=True, blank=True, verbose_name="动作详情描述")
    # add at hera 1.11
    package_new = models.IntegerField(verbose_name=u'动作所在的模块', choices=HERA_OPERATE_LOG_PACKAGE)
    action_new = models.IntegerField(verbose_name=u'动作名称', choices=HERA_OPERATE_LOG_ACTION)

    @property
    def object_id(self):
        return self.object_id_json

    @object_id.setter
    def object_id(self, value):
        self.object_id_json = value
