# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from .tag import Tag


class Channel(models.Model):
    """
    频道
    """

    class Meta:
        verbose_name = u'频道'
        verbose_name_plural = u'频道'
        db_table = 'api_channel'
        app_label = 'api'

    name = models.CharField(verbose_name=u'频道名', max_length=20)
    icon = models.CharField(verbose_name=u'图标', max_length=100, default=u'', blank=True)
    ordering = models.IntegerField(default=10, verbose_name=u"展示顺序", help_text=u"小的排在前，大的排在后")
    tag = models.ForeignKey(Tag, null=True, blank=True)

    def channel_data(self):
        return {
            'name': self.name,
            'tag_type': u'channel',
            'id': self.id,
            'icon': self.icon,
        }

    def __unicode__(self):
        return self.name


class ChannelImage(models.Model):
    class Meta:
        db_table = u'api_channel_image'
        verbose_name = u'频道图片'
        verbose_name_plural = u'频道图片'
        app_label = 'api'

    channel = models.ForeignKey(Channel, related_name='images')
    image_url = models.CharField(max_length=300, verbose_name=u'图片')

    def __unicode__(self):
        return u'<%s><Topic:%s><Image_url: %s>' % (self.id, self.channel, self.image_url)