# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

import redis
import json

from django.conf import settings
from .common import RedisClient

game_pool = redis.ConnectionPool(**settings.REDIS['game'])


class GameGoddessClient(RedisClient):
    prefix = "api_game_goddess_my_service"
    pool = game_pool

    def get(self, key):
        key = self._get_key(key)
        result = self.client.get(key)
        if result:
            return json.loads(result)
        else:
            return {
                'history': [],
                'total_discount': 0,
            }

    def set(self, key, value):
        key = self._get_key(key)
        self.client.set(key, json.dumps(value))

    def delete(self, key):
        key = self._get_key(key)
        self.client.delete(key)

class GameWishtreeClient(RedisClient):
    prefix = "api_game_wishtree"
    pool = game_pool

    def get(self, key):
        key = self._get_key(key)
        result = self.client.get(key)
        if result:
            return json.loads(result)
        else:
            return {
                'history': [],
                'total_discount': settings.GAME_WISHTREE_COUPON_VALUE,
                'count': 1,
            }

    def set(self, key, value):
        key = self._get_key(key)
        self.client.set(key, json.dumps(value))
