# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from .tag import Tag

# TODO Skyler 迁移
from hippo.models.hospital import Hospital, HospitalFavor


# TODO Skyler HospitalTag Deprecated
class HospitalTag(models.Model):
    class Meta:
        app_label = 'api'

    hospital = models.ForeignKey(Hospital)
    tag = models.ForeignKey(Tag)

    def __unicode__(self):
        return "%s:%s" % (self.tag.name, self.hospital.name)


class PeriodHospital(models.Model):
    class Meta:
        verbose_name = u'分期白名单医院'
        app_label = 'api'
        db_table = 'api_period_hospital'

    hospital = models.OneToOneField(Hospital)
    period_id = models.CharField(max_length=64, unique=True, verbose_name=u'医院id的md5')
    is_online = models.BooleanField('是否生效', default=True)
    default_online = models.BooleanField('新增美购默认分期', default=True)
    create_time = models.DateTimeField(auto_now_add=True)

    @classmethod
    def check_hospital_in_list(cls, hospital):
        return PeriodHospital.objects.filter(hospital=hospital, is_online=True).exists()

    @classmethod
    def get_hospital_ids_in_list(cls, hospital_ids):
        return PeriodHospital.objects.filter(
            hospital_id__in=hospital_ids, is_online=True).values_list('hospital_id', flat=True)
