# coding:utf-8

from datetime import datetime, date, timedelta

from celery import shared_task
from gm_types.gaia import FREER_RECRUITMENT_PUSH_TYPE

from api.models.freerecruitment import ReservationUser
from api.models.freerecruitment import FreeRecruitment
from api.models.freerecruitment import ThirdAccountInfo
from api.models.freerecruitment import FreeRecruitmentUser

from api.util.user_util import simple_user_info_by_user_ids
from api.services.free_recruitment_service import FreeRecruitmentPushService


@shared_task
def activity_started_subscriber_push():
    """活动开始，预约的人进行push"""

    today = date.today()
    min_time = datetime.min.time()
    today_start = datetime.combine(today, min_time)

    activites = FreeRecruitment.objects.filter(is_online=True, start_time=today_start)
    for activity in activites:
        extra_info = {
            "start_time": activity.start_time,
            "end_time": activity.end_time,
            "activity_title": activity.title,
        }

        user_ids = list(ReservationUser.objects.filter(freerecruitment_id=activity.id).values_list("user_id", flat=True))
        if not user_ids:
            continue

        users = simple_user_info_by_user_ids(user_ids)
        users_form_id = ThirdAccountInfo.list(push_type=FREER_RECRUITMENT_PUSH_TYPE.ACTIVITY_STARTED, user_ids=user_ids)
        for user in users.values():
            form_id = users_form_id.get(user["user_id"], {}).get(activity.id)
            if not form_id:
                continue

            FreeRecruitmentPushService.send_template_msg(
                push_type=FREER_RECRUITMENT_PUSH_TYPE.ACTIVITY_STARTED,
                extra_info=extra_info, user=user, form_id=form_id,
                page="/pages/recruit/detail/main?id={}".format(activity.id),
            )
            info = ThirdAccountInfo.objects.get(form_id=form_id)
            info.is_online=False
            info.save()


@shared_task
def activity_ended_push():
    """活动结束推送，参加的人进行push"""

    yesterday = datetime.today() + timedelta(-1)
    min_time = datetime.min.time()
    yesterday = datetime.combine(yesterday, min_time)
    yesterday=yesterday.replace(hour=23, minute=59, second=59)
    activites = FreeRecruitment.objects.filter(is_online=True, end_time=yesterday)
    for activity in activites:
        user_ids = list(FreeRecruitmentUser.objects.filter(freerecruitment_id=activity.id).values_list("user_id", flat=True))
        if not user_ids:
            continue
        users = simple_user_info_by_user_ids(user_ids)
        users_form_id = ThirdAccountInfo.list(push_type=FREER_RECRUITMENT_PUSH_TYPE.ACTIVITY_ENDED, user_ids=user_ids)
        for user in users.values():
            extra_info = {
                "nick_name": user["nick_name"],
                "activity_title":  activity.title
            }

            form_id = users_form_id.get(user["user_id"], {}).get(activity.id)
            if not form_id:
                continue

            FreeRecruitmentPushService.send_template_msg(
                push_type=FREER_RECRUITMENT_PUSH_TYPE.ACTIVITY_ENDED,
                extra_info=extra_info, user=user, form_id=form_id,
                page="/pages/home/main",
            )
            info = ThirdAccountInfo.objects.get(form_id=form_id)
            info.is_online=False
            info.save()