# -*- coding: UTF-8 -*-

from rpc.context import get_rpc_remote_invoker
from rpc.tool.log_tool import logging_exception
from rpc.decorators import cache_page


@cache_page(300)
def get_index_banner_diary_info_by_ids(diary_ids):
    try:
        rpc_invoker = get_rpc_remote_invoker()
        result = rpc_invoker['diary/get_index_banner_diary_by_ids'](diary_ids=diary_ids).unwrap()
        result = {int(k): v for k, v in result.iteritems()}  # Python 3.5.2 不支持已int为字典key
        return result

    except:
        logging_exception()
        return {}
