# -*- coding:utf-8 -*-
'''
设备用户相关
'''

from gm_types.error import ERROR as ERROR_CODES

from statistic.models import Device
from api.models import DeviceCategory
from rpc.tool.error_code import gen
from rpc.decorators import bind


@bind('account/device/exists')
def exists_device_id(device_id):
    '''
    判断设备id是否已经存在
    '''
    return Device.exists_device_id(device_id)


@bind('account/device/save_category')
def device_save_category(device_id, category_id_list):
    '''
    新设备选择个性化品类
    '''
    if not all([device_id, category_id_list]):
        gen(ERROR_CODES.INVALID_PARAMS)
    _suc, _rea = DeviceCategory.create(device_id, category_id_list)
    if _suc:
        return {'success': True}
    else:
        return {'success': False, 'message': _rea}


@bind('account/device/category/binded')
def device_category_binded(device_id):
    return DeviceCategory.binded(device_id)


@bind('account/device/category/placeholer')
def device_category_placeholder(device_id):
    DeviceCategory.placeholder(device_id)
