# coding=utf-8

from __future__ import unicode_literals, absolute_import, print_function

from rpc.decorators import bind
from rpc.tool.dict_mixin import to_dict
from rpc.tool.error_code import gen
from rpc.tool.error_code import CODES
from api.models import Share


@bind('api/share/by_id')
def share_by_id(id):
    model = Share
    try:
        m = model.objects.get(id=id)
        if hasattr(m, 'to_dict'):
            return m.to_dict()
        else:
            return to_dict(m)
    except model.DoesNotExist:
        return gen(CODES.SHARE_NOT_FOUND)
