# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='CashBackAuditLog',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('status', models.CharField(default=1, max_length=2, verbose_name='\u5ba1\u6838\u72b6\u6001', choices=[(0, '\u5df2\u901a\u8fc7'), (1, '\u5ba1\u6838\u4e2d'), (2, '\u5df2\u9a73\u56de')])),
                ('time', models.DateTimeField(auto_now_add=True, verbose_name='\u5ba1\u6838\u65f6\u95f4')),
                ('reason', models.CharField(max_length=2, null=True, verbose_name='\u9a73\u56de\u539f\u56e0', choices=[('0', '\u9080\u8bf7\u7684\u591a\u4e2a\u7528\u6237\u5728\u540c\u4e00\u8bbe\u5907\u767b\u5f55'), ('2', '\u77ed\u65f6\u95f4\u5185\u9080\u8bf7\u4e86\u5927\u91cf\u7528\u6237'), ('3', '\u5176\u4ed6'), ('1', '\u9080\u8bf7\u7684\u591a\u4e2a\u7528\u6237\u5728\u5341\u5206\u949f\u5185\u767b\u5f55')])),
            ],
        ),
        migrations.CreateModel(
            name='Dialog',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('type', models.SmallIntegerField(unique=True, choices=[('1', '\u73b0\u91d1\u7ea2\u5305'), ('0', '\u9080\u8bf7\u7ea2\u5305')])),
                ('packet_id', models.IntegerField(verbose_name=b'\xe5\x85\xb3\xe8\x81\x94\xe7\xba\xa2\xe5\x8c\x85ID')),
            ],
        ),
        migrations.CreateModel(
            name='DialogAction',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('action', models.SmallIntegerField(choices=[(1, b'\xe6\x89\x93\xe5\xbc\x80\xe5\xbc\xb9\xe7\xaa\x97'), (0, b'\xe5\x85\xb3\xe9\x97\xad\xe5\xbc\xb9\xe7\xaa\x97')])),
                ('device_id', models.CharField(max_length=64, verbose_name=b'\xe8\xae\xbe\xe5\xa4\x87ID')),
                ('create_at', models.DateTimeField(auto_now_add=True)),
                ('dialog', models.ForeignKey(verbose_name=b'\xe5\x85\xb3\xe8\x81\x94\xe5\xbc\xb9\xe7\xaa\x97', to='cashback.Dialog')),
                ('user', models.ForeignKey(verbose_name=b'\xe5\x85\xb3\xe8\x81\x94\xe7\x94\xa8\xe6\x88\xb7', blank=True, to=settings.AUTH_USER_MODEL, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='RedPacket',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('packet_type', models.CharField(default='0', max_length=2, verbose_name='\u7ea2\u5305\u7c7b\u578b', choices=[('1', '\u73b0\u91d1\u7ea2\u5305'), ('0', '\u9080\u8bf7\u7ea2\u5305')])),
                ('amount', models.FloatField(default=0, verbose_name='\u7ea2\u5305\u91d1\u989d')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='\u521b\u5efa\u65f6\u95f4')),
                ('is_online', models.BooleanField(default=False, verbose_name='\u662f\u5426\u4e0a\u7ebf')),
            ],
        ),
        migrations.CreateModel(
            name='Registration',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('device_id', models.CharField(max_length=64, null=True, blank=True)),
                ('device_type', models.CharField(max_length=32, null=True, blank=True)),
                ('activated', models.BooleanField(default=False, verbose_name='\u5df2\u6fc0\u6d3b')),
                ('register_time', models.DateTimeField(null=True, blank=True)),
                ('login_time', models.DateTimeField(null=True, blank=True)),
                ('invitee', models.ForeignKey(related_name='invitee', verbose_name='\u88ab\u9080\u8bf7\u8005', to=settings.AUTH_USER_MODEL)),
                ('inviter', models.ForeignKey(related_name='inviter', verbose_name='\u9080\u8bf7\u8005', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='TransactionLog',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('amount', models.IntegerField(verbose_name='\u4ea4\u6613\u91d1\u989d')),
                ('type', models.SmallIntegerField(db_index=True, verbose_name='\u4ea4\u6613\u7c7b\u578b', choices=[(0, '\u6536\u5165'), (1, '\u63d0\u73b0')])),
                ('state', models.SmallIntegerField(default=1, verbose_name='\u4ea4\u6613\u72b6\u6001', choices=[(0, '\u5df2\u901a\u8fc7'), (1, '\u5ba1\u6838\u4e2d'), (2, '\u5df2\u9a73\u56de')])),
                ('create_at', models.DateTimeField(auto_now_add=True)),
                ('update_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='TransactionRemark',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('event_type', models.SmallIntegerField(choices=[(1, '\u9080\u8bf7\u7ea2\u5305'), (2, '\u7528\u6237\u63d0\u73b0'), (0, '\u73b0\u91d1\u7ea2\u5305')])),
                ('packet_id', models.IntegerField(null=True, blank=True)),
                ('registration_id', models.IntegerField(null=True, blank=True)),
                ('cdkey', models.CharField(max_length=32, null=True, verbose_name='\u5151\u6362\u7801', blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='UserBalance',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('join_time', models.DateTimeField(auto_now_add=True, verbose_name='\u52a0\u5165\u65f6\u95f4')),
                ('user', models.OneToOneField(verbose_name='\u7528\u6237', to=settings.AUTH_USER_MODEL, unique=True)),
            ],
        ),
        migrations.AddField(
            model_name='transactionlog',
            name='remark',
            field=models.OneToOneField(null=True, blank=True, to='cashback.TransactionRemark', verbose_name='\u4ea4\u6613\u5907\u6ce8'),
        ),
        migrations.AddField(
            model_name='transactionlog',
            name='user',
            field=models.ForeignKey(to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='cashbackauditlog',
            name='transactionlog',
            field=models.ForeignKey(verbose_name='\u5173\u8054\u6d41\u6c34\u8bb0\u5f55', to='cashback.TransactionLog'),
        ),
        migrations.AddField(
            model_name='cashbackauditlog',
            name='user',
            field=models.ForeignKey(verbose_name='\u5ba1\u6838\u4eba\u5458', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterUniqueTogether(
            name='registration',
            unique_together=set([('inviter', 'invitee')]),
        ),
    ]
