# coding=utf-8
from __future__ import unicode_literals

from api.models import (
        Province, UserExtra, BodyPart,
    )
from api.tool.user_tool import get_user_from_context
from rpc.decorators import bind_context
from statistic import const_strings


@bind_context('doctor/topic/filter')
def topic_filter(ctx):
    """##话题筛选器 条件数据
    """
    data = {}
    provinces = Province.objects.filter(display_in_filter=True)
    data['provinces'] = [{'id': p.id, 'name': p.name} for p in provinces]

    user = get_user_from_context(ctx)
    try:
        user_profile = UserExtra.objects.get(user_id=user.id)
        user_city = user_profile.city if user_profile else None
        user_province = user_city.province if user_city else None
    except:
        user_province = None

    if user_province:
        data['user_location'] = {
            'id': user_province.id,
            'name': user_province.name
        }
    else:
        data['user_location'] = {
            'id': const_strings.NATIONWIDE,
            'name': '全国'
        }

    data['provinces'].insert(0, {'id': const_strings.NATIONWIDE, 'name': '全国'})
    sections = BodyPart.objects.filter(is_deleted=False).order_by('rank')
    # TODO Deprecated 在iOS重构的时候添加的id，tag_id 可以考虑以后去掉 大概iOS重构版本是2.6.0
    data['sections'] = [{'tag_id': s.tag.id, 'id': s.tag.id, 'name': s.name} for s in sections]
    data['sections'].insert(0, {'tag_id': const_strings.ALL, 'id': const_strings.ALL, 'name': u'全部项目'})
    return data