"""
__author__ = 'xumingming'
"""
import datetime
import random

from django.core.management import BaseCommand

from api.models import City,Tag
from doris.models import SearchRank,HospitalConversion,DoctorConversion,TagConversion


class Command(BaseCommand):
    def handle(self, *args, **options):
        word_set = list(Tag.objects.filter(tag_type__in=['1', '2', '3'], is_online=True).values('name', 'id'))
        province_set = City.objects.filter(is_online=True).values_list('province_id',flat=True)
        date_set = [datetime.date.today(), datetime.date.today() + datetime.timedelta(-1)]

        print('start create data')
        for province_id in province_set:
            for i in range(3):
                tag = random.choice(word_set)
                try:
                    TagConversion.objects.create(
                        business_id=tag['id'],
                        query=tag['name'],
                        province_id=province_id,
                        update_date=random.choice(date_set),
                        search_rate=random.random(),
                        conversion_rate=random.random()
                    )

                    DoctorConversion.objects.create(
                        business_id=tag['id'],
                        query=tag['name'],
                        province_id=province_id,
                        update_date=random.choice(date_set),
                        search_rate=random.random(),
                        conversion_rate=random.random()
                    )

                    HospitalConversion.objects.create(
                        business_id=tag['id'],
                        query=tag['name'],
                        province_id=province_id,
                        update_date=random.choice(date_set),
                        search_rate=random.random(),
                        conversion_rate=random.random()
                    )

                    SearchRank.objects.create(
                        province_id=province_id,
                        update_date=random.choice(date_set),
                        search_cnt=random.randint(1, 99999),
                        query=tag['name']
                    )
                except :
                    continue

        print('done!')