# -*- coding: UTF-8 -*-
from django.core.management import BaseCommand

from api.models import Tag, WordRel
from gm_types.gaia import WORDREL_CATEGORY
from rpc.tool.queryset_tool import big_qs_iter
from rpc.exceptions import GaiaRPCFaultException


class Command(BaseCommand):
    """初始化同义近义词库, 导入所有123级在线标签
    """
    def handle(self, *args, **options):
        tags = Tag.objects.filter(tag_type__in=['1', '2', '3'], is_online=True)
        for tag in big_qs_iter(tags, trace=True):
            try:
                WordRel.check_constraint([tag.name])
                print tag.id, tag.name
                obj = WordRel.objects.create(keyword=tag.name, category=WORDREL_CATEGORY.ITEM)
                obj.save_synonym_words([tag.name])
            except GaiaRPCFaultException:
                print tag.id, tag.name, 'constraint'
                pass
            except:
                raise
